//***************************************************************************************** 
// Description: GPL162xx serial PPU API
// Plateform: GPL162xx, unSP IDE 
// Edited and Created by Generalplus Technology Co., Ltd. 
//***************************************************************************************** 
#ifndef	__PPUDRV_H__
#define	__PPUDRV_H__
//=========================================================================================
// Type Definition AREA
//=========================================================================================
typedef unsigned int	U16;
typedef int	S16;
typedef unsigned long	U32;
typedef long	S32;
typedef struct 										//SPRITE Struct
{
	int 				Idx;						// ID number (0 ~ 32767)
	int					x;							// X Position
	int					y;							// Y Position
	int					xSize;						// Sprite x size 
	int					ySize;						// Sprite y size 
	const int			*sprcell;					// Sprite cell data set
	int					att0;						// Sprite attribute 0
	int					att1;						// Sprite attribute 1 	
	int					x1;							// X1 position 
	int					x2;							// X2 position 
	int					x3;							// X3 position
	int					y1;		 					// Y1 position
	int                 y2;							// Y2 position
	int                 y3;							// Y3 position	
} SPRITE;

//=========================================================================================
// Contant Defintion Area
//=========================================================================================
//The following defined constant can be modified by the user for his applcation 
#define                 SP_MAX_CHAR         64		// Maximum Combination Character To Consist Of One 2D Sprite
#define 				MAX_INDEX_LENGTH	1024	// Maximum Index Table Length  
#define 				MAX_ATT_LENGTH	    512		// Maximum Attribute Table Length 
//The following defined constant can't be modified by the user 
#define 				CELL_LENGTH 		17		// One Cell data length for Sprite
#define 				ATT_LENGTH	 		9		// Attribute0 data length for Sprite
#define 				ATT_LENGTH2	 		3		// Attribute1 data length for Sprite
#define 				QVGA_SCREENWIDTH 	320		// Screen Width of QVGA
#define 				QVGA_SCREENHEIGHT 	240		// Screen Height of QVGA
//------------------------------------------------------------------------------------------------------
// Define Sprite Rotate Level 0 - 63
//------------------------------------------------------------------------------------------------------
#define					SP_ROTATE0			(0 << 10)
#define					SP_ROTATE1			(1 << 10)
#define					SP_ROTATE2			(2 << 10)
#define					SP_ROTATE3			(3 << 10)
#define					SP_ROTATE4			(4 << 10)
#define					SP_ROTATE5			(5 << 10)
#define					SP_ROTATE6			(6 << 10)
#define					SP_ROTATE7			(7 << 10)
#define					SP_ROTATE8			(8 << 10)
#define					SP_ROTATE9			(9 << 10)
#define					SP_ROTATE10			(10 << 10)
#define					SP_ROTATE11			(11 << 10)
#define					SP_ROTATE12			(12 << 10)
#define					SP_ROTATE13			(13 << 10)
#define					SP_ROTATE14			(14 << 10)
#define					SP_ROTATE15			(15 << 10)
#define					SP_ROTATE16			(16 << 10)
#define					SP_ROTATE17			(17 << 10)
#define					SP_ROTATE18			(18 << 10)
#define					SP_ROTATE19			(19 << 10)
#define					SP_ROTATE20			(20 << 10)
#define					SP_ROTATE21			(21 << 10)
#define					SP_ROTATE22			(22 << 10)
#define					SP_ROTATE23			(23 << 10)
#define					SP_ROTATE24			(24 << 10)
#define					SP_ROTATE25			(25 << 10)
#define					SP_ROTATE26			(26 << 10)
#define					SP_ROTATE27			(27 << 10)
#define					SP_ROTATE28			(28 << 10)
#define					SP_ROTATE29			(29 << 10)
#define					SP_ROTATE30			(30 << 10)
#define					SP_ROTATE31			(31 << 10)
#define					SP_ROTATE32			(32 << 10)
#define					SP_ROTATE33			(33 << 10)
#define					SP_ROTATE34			(34 << 10)
#define					SP_ROTATE35			(35 << 10)
#define					SP_ROTATE36			(36 << 10)
#define					SP_ROTATE37			(37 << 10)
#define					SP_ROTATE38			(38 << 10)
#define					SP_ROTATE39			(39 << 10)
#define					SP_ROTATE40			(40 << 10)
#define					SP_ROTATE41			(41 << 10)
#define					SP_ROTATE42			(42 << 10)
#define					SP_ROTATE43			(43 << 10)
#define					SP_ROTATE44			(44 << 10)
#define					SP_ROTATE45			(45 << 10)
#define					SP_ROTATE46			(46 << 10)
#define					SP_ROTATE47			(47 << 10)
#define					SP_ROTATE48			(48 << 10)
#define					SP_ROTATE49			(49 << 10)
#define					SP_ROTATE50			(50 << 10)
#define					SP_ROTATE51			(51 << 10)
#define					SP_ROTATE52			(52 << 10)
#define					SP_ROTATE53			(53 << 10)
#define					SP_ROTATE54			(54 << 10)
#define					SP_ROTATE55			(55 << 10)
#define					SP_ROTATE56			(56 << 10)
#define					SP_ROTATE57			(57 << 10)
#define					SP_ROTATE58			(58 << 10)
#define					SP_ROTATE59			(59 << 10)
#define					SP_ROTATE60			(60 << 10)
#define					SP_ROTATE61			(61 << 10)
#define					SP_ROTATE62			(62 << 10)
#define					SP_ROTATE63			(63 << 10)
//------------------------------------------------------------------------------------------------------
// Define Sprite Zoom Level 0 - 63
//------------------------------------------------------------------------------------------------------
#define					SP_ZOOM0			(0 << 10)
#define					SP_ZOOM1			(1 << 10)
#define					SP_ZOOM2			(2 << 10)
#define					SP_ZOOM3			(3 << 10)
#define					SP_ZOOM4			(4 << 10)
#define					SP_ZOOM5			(5 << 10)
#define					SP_ZOOM6			(6 << 10)
#define					SP_ZOOM7			(7 << 10)
#define					SP_ZOOM8			(8 << 10)
#define					SP_ZOOM9			(9 << 10)
#define					SP_ZOOM10			(10 << 10)
#define					SP_ZOOM11			(11 << 10)
#define					SP_ZOOM12			(12 << 10)
#define					SP_ZOOM13			(13 << 10)
#define					SP_ZOOM14			(14 << 10)
#define					SP_ZOOM15			(15 << 10)
#define					SP_ZOOM16			(16 << 10)
#define					SP_ZOOM17			(17 << 10)
#define					SP_ZOOM18			(18 << 10)
#define					SP_ZOOM19			(19 << 10)
#define					SP_ZOOM20			(20 << 10)
#define					SP_ZOOM21			(21 << 10)
#define					SP_ZOOM22			(22 << 10)
#define					SP_ZOOM23			(23 << 10)
#define					SP_ZOOM24			(24 << 10)
#define					SP_ZOOM25			(25 << 10)
#define					SP_ZOOM26			(26 << 10)
#define					SP_ZOOM27			(27 << 10)
#define					SP_ZOOM28			(28 << 10)
#define					SP_ZOOM29			(29 << 10)
#define					SP_ZOOM30			(30 << 10)
#define					SP_ZOOM31			(31 << 10)
#define					SP_ZOOM32			(32 << 10)
#define					SP_ZOOM33			(33 << 10)
#define					SP_ZOOM34			(34 << 10)
#define					SP_ZOOM35			(35 << 10)
#define					SP_ZOOM36			(36 << 10)
#define					SP_ZOOM37			(37 << 10)
#define					SP_ZOOM38			(38 << 10)
#define					SP_ZOOM39			(39 << 10)
#define					SP_ZOOM40			(40 << 10)
#define					SP_ZOOM41			(41 << 10)
#define					SP_ZOOM42			(42 << 10)
#define					SP_ZOOM43			(43 << 10)
#define					SP_ZOOM44			(44 << 10)
#define					SP_ZOOM45			(45 << 10)
#define					SP_ZOOM46			(46 << 10)
#define					SP_ZOOM47			(47 << 10)
#define					SP_ZOOM48			(48 << 10)
#define					SP_ZOOM49			(49 << 10)
#define					SP_ZOOM50			(50 << 10)
#define					SP_ZOOM51			(51 << 10)
#define					SP_ZOOM52			(52 << 10)
#define					SP_ZOOM53			(53 << 10)
#define					SP_ZOOM54			(54 << 10)
#define					SP_ZOOM55			(55 << 10)
#define					SP_ZOOM56			(56 << 10)
#define					SP_ZOOM57			(57 << 10)
#define					SP_ZOOM58			(58 << 10)
#define					SP_ZOOM59			(59 << 10)
#define					SP_ZOOM60			(60 << 10)
#define					SP_ZOOM61			(61 << 10)
#define					SP_ZOOM62			(62 << 10)
#define					SP_ZOOM63			(63 << 10)
//------------------------------------------------------------------------------------------------------
// Define Sprite Blend Level 0 - 63
//------------------------------------------------------------------------------------------------------
#define					SPBLEND_LEVEL0			(0 << 8)
#define					SPBLEND_LEVEL1			(1 << 8)
#define					SPBLEND_LEVEL2			(2 << 8)
#define					SPBLEND_LEVEL3			(3 << 8)
#define					SPBLEND_LEVEL4			(4 << 8)
#define					SPBLEND_LEVEL5			(5 << 8)
#define					SPBLEND_LEVEL6			(6 << 8)
#define					SPBLEND_LEVEL7			(7 << 8)
#define					SPBLEND_LEVEL8			(8 << 8)
#define					SPBLEND_LEVEL9			(9 << 8)
#define					SPBLEND_LEVEL10			(10 << 8)
#define					SPBLEND_LEVEL11			(11 << 8)
#define					SPBLEND_LEVEL12			(12 << 8)
#define					SPBLEND_LEVEL13			(13 << 8)
#define					SPBLEND_LEVEL14			(14 << 8)
#define					SPBLEND_LEVEL15			(15 << 8)
#define					SPBLEND_LEVEL16			(16 << 8)
#define					SPBLEND_LEVEL17			(17 << 8)
#define					SPBLEND_LEVEL18			(18 << 8)
#define					SPBLEND_LEVEL19			(19 << 8)
#define					SPBLEND_LEVEL20			(20 << 8)
#define					SPBLEND_LEVEL21			(21 << 8)
#define					SPBLEND_LEVEL22			(22 << 8)
#define					SPBLEND_LEVEL23			(23 << 8)
#define					SPBLEND_LEVEL24			(24 << 8)
#define					SPBLEND_LEVEL25			(25 << 8)
#define					SPBLEND_LEVEL26			(26 << 8)
#define					SPBLEND_LEVEL27			(27 << 8)
#define					SPBLEND_LEVEL28			(28 << 8)
#define					SPBLEND_LEVEL29			(29 << 8)
#define					SPBLEND_LEVEL30			(30 << 8)
#define					SPBLEND_LEVEL31			(31 << 8)
#define					SPBLEND_LEVEL32			(32 << 8)
#define					SPBLEND_LEVEL33			(33 << 8)
#define					SPBLEND_LEVEL34			(34 << 8)
#define					SPBLEND_LEVEL35			(35 << 8)
#define					SPBLEND_LEVEL36			(36 << 8)
#define					SPBLEND_LEVEL37			(37 << 8)
#define					SPBLEND_LEVEL38			(38 << 8)
#define					SPBLEND_LEVEL39			(39 << 8)
#define					SPBLEND_LEVEL40			(40 << 8)
#define					SPBLEND_LEVEL41			(41 << 8)
#define					SPBLEND_LEVEL42			(42 << 8)
#define					SPBLEND_LEVEL43			(43 << 8)
#define					SPBLEND_LEVEL44			(44 << 8)
#define					SPBLEND_LEVEL45			(45 << 8)
#define					SPBLEND_LEVEL46			(46 << 8)
#define					SPBLEND_LEVEL47			(47 << 8)
#define					SPBLEND_LEVEL48			(48 << 8)
#define					SPBLEND_LEVEL49			(49 << 8)
#define					SPBLEND_LEVEL50			(50 << 8)
#define					SPBLEND_LEVEL51			(51 << 8)
#define					SPBLEND_LEVEL52			(52 << 8)
#define					SPBLEND_LEVEL53			(53 << 8)
#define					SPBLEND_LEVEL54			(54 << 8)
#define					SPBLEND_LEVEL55			(55 << 8)
#define					SPBLEND_LEVEL56			(56 << 8)
#define					SPBLEND_LEVEL57			(57 << 8)
#define					SPBLEND_LEVEL58			(58 << 8)
#define					SPBLEND_LEVEL59			(59 << 8)
#define					SPBLEND_LEVEL60			(60 << 8)
#define					SPBLEND_LEVEL61			(61 << 8)
#define					SPBLEND_LEVEL62			(62 << 8)
#define					SPBLEND_LEVEL63			(63 << 8)
//------------------------------------------------------------------------------------------------------
// Define Sprite Mosaic Level 0 - 3
//------------------------------------------------------------------------------------------------------
#define					SP_MOSAIC0			(0 << 14)
#define					SP_MOSAIC1			(1 << 14)
#define					SP_MOSAIC2			(2 << 14)
#define					SP_MOSAIC3			(3 << 14)
//------------------------------------------------------------------------------------------------------
// Define Sprite 16-bit Palette Select
//------------------------------------------------------------------------------------------------------
#define					SP_PBANK0			(0 << 15)	
#define					SP_PBANK1			(1 << 15)   
//------------------------------------------------------------------------------------------------------
// Define Sprite Blending Effect Disable/Enable
//------------------------------------------------------------------------------------------------------
#define					SPBLEND_DISABLE		(0 << 14)	// Set Sprite Blending effect disable
#define					SPBLEND_ENABLE		(1 << 14)   // Set Sprite Blending effect enable
//------------------------------------------------------------------------------------------------------
// Define Sprite Depth 0 - 3
//------------------------------------------------------------------------------------------------------
#define					SP_DEPTH1 			(0 << 12)	
#define					SP_DEPTH3 			(1 << 12)	
#define					SP_DEPTH5 			(2 << 12)	
#define					SP_DEPTH7 			(3 << 12)	
//------------------------------------------------------------------------------------------------------
// Define Sprite Palette bank 0 - 15
//------------------------------------------------------------------------------------------------------
#define					SP_PALETTE0 		(0 << 8)	
#define					SP_PALETTE1 		(1 << 8)
#define					SP_PALETTE2 		(2 << 8)
#define					SP_PALETTE3 		(3 << 8)
#define					SP_PALETTE4 		(4 << 8)
#define					SP_PALETTE5 		(5 << 8)
#define					SP_PALETTE6 		(6 << 8)
#define					SP_PALETTE7 		(7 << 8)
#define					SP_PALETTE8 		(8 << 8)
#define					SP_PALETTE9 		(9 << 8)
#define					SP_PALETTE10 		(10 << 8)
#define					SP_PALETTE11 		(11 << 8)
#define					SP_PALETTE12 		(12 << 8)
#define					SP_PALETTE13 		(13 << 8)
#define					SP_PALETTE14 		(14 << 8)
#define					SP_PALETTE15 		(15 << 8)
//------------------------------------------------------------------------------------------------------
// Define Sprite Character size for Y
//------------------------------------------------------------------------------------------------------
#define					SP_VSIZE8 			(0 << 6)	
#define					SP_VSIZE16 			(1 << 6)	
#define					SP_VSIZE32 			(2 << 6)	
#define					SP_VSIZE64 			(3 << 6)	
//------------------------------------------------------------------------------------------------------
// Define Sprite Character size for X
//------------------------------------------------------------------------------------------------------
#define					SP_HSIZE8 			(0 << 4)	
#define					SP_HSIZE16 			(1 << 4)
#define					SP_HSIZE32 			(2 << 4)
#define					SP_HSIZE64 			(3 << 4)
//------------------------------------------------------------------------------------------------------
// Define Sprite H/V-Flip Disable/Enable 
//------------------------------------------------------------------------------------------------------
#define					SPVFLIP_DISABLE 	0x0000	
#define					SPVFLIP_ENABLE 		0x0008	
#define					SPHFLIP_DISABLE 	0x0000	
#define					SPHFLIP_ENABLE 		0x0004	
//------------------------------------------------------------------------------------------------------
// Define Sprite Color Mode
//------------------------------------------------------------------------------------------------------
#define					SP_COLOR4 			0x0000
#define					SP_COLOR16 			0x0001
#define					SP_COLOR64 			0x0002
#define					SP_COLOR256 		0x0003
//------------------------------------------------------------------------------------------------------
// Sprite Palette page 0 to 15
//------------------------------------------------------------------------------------------------------
#define					SpPalettePage0    	0x0
#define					SpPalettePage1    	0x1
#define 				SpPalettePage2    	0x2
#define 				SpPalettePage3    	0x3
#define 				SpPalettePage4    	0x4
#define 				SpPalettePage5    	0x5
#define 				SpPalettePage6    	0x6
#define 				SpPalettePage7    	0x7
#define 				SpPalettePage8    	0x8
#define 				SpPalettePage9    	0x9
#define 				SpPalettePage10   	0xa
#define 				SpPalettePage11   	0xb
#define 				SpPalettePage12   	0xc
#define 				SpPalettePage13   	0xd
#define 				SpPalettePage14   	0xe
#define 				SpPalettePage15   	0xf
//------------------------------------------------------------------------------------------------------
// Sprite Depth
//------------------------------------------------------------------------------------------------------
#define 				SpriteDepth1      	0x0
#define 				SpriteDepth3        0x1
#define 				SpriteDepth5        0x2
#define 				SpriteDepth7       	0x3
//------------------------------------------------------------------------------------------------------
// Text Color mode 4/16/64/256/32768/65536
//------------------------------------------------------------------------------------------------------
#define 				COLOR4           	0x0
#define 				COLOR16         	0x1
#define 				COLOR64         	0x2
#define 				COLOR256        	0x3
#define 				COLOR32768        	0x4
#define 				COLOR65536        	0x5
//------------------------------------------------------------------------------------------------------
// Character horizontal size 8/16/32/64
//------------------------------------------------------------------------------------------------------
#define 				H_SIZE8    	    	8
#define 				H_SIZE16	       	16
#define 				H_SIZE32      		32
#define 				H_SIZE64      		64
//------------------------------------------------------------------------------------------------------
// Character vertical size/8/16/32/64
//------------------------------------------------------------------------------------------------------
#define 				V_SIZE8             8
#define 				V_SIZE16	        16
#define					V_SIZE32            32
#define					V_SIZE64            64
//------------------------------------------------------------------------------------------------------
// Text Palette page 0 to 15
//------------------------------------------------------------------------------------------------------
#define					TextPalettePage0    0x0
#define					TextPalettePage1    0x1
#define 				TextPalettePage2    0x2
#define 				TextPalettePage3    0x3
#define 				TextPalettePage4    0x4
#define 				TextPalettePage5    0x5
#define 				TextPalettePage6    0x6
#define 				TextPalettePage7    0x7
#define 				TextPalettePage8    0x8
#define 				TextPalettePage9    0x9
#define 				TextPalettePage10   0xa
#define 				TextPalettePage11   0xb
#define 				TextPalettePage12   0xc
#define 				TextPalettePage13   0xd
#define 				TextPalettePage14   0xe
#define 				TextPalettePage15   0xf
//------------------------------------------------------------------------------------------------------
// Text Depth 0 to 3
//------------------------------------------------------------------------------------------------------
#define 				TextDepth0          0x0
#define 				TextDepth2          0x1
#define 				TextDepth4          0x2
#define 				TextDepth6          0x3
//------------------------------------------------------------------------------------------------------
// Text mode character/linear mode
//------------------------------------------------------------------------------------------------------
#define 				Text_CharMode       0x0
#define 				Text_LinerMode      0x1
//------------------------------------------------------------------------------------------------------
// Text attribute in array/register
//------------------------------------------------------------------------------------------------------
#define 				Text_AttInArray     0x0
#define 				Text_AttInRegister  0x1
//------------------------------------------------------------------------------------------------------
// 4-level Blending Level
//------------------------------------------------------------------------------------------------------
#define 				BlendLevel0         0x0
#define 				BlendLevel1         0x1
#define 				BlendLevel2         0x2
#define 				BlendLevel3         0x3
//------------------------------------------------------------------------------------------------------
// Define Text select
//------------------------------------------------------------------------------------------------------
#define					TEXT1				0x0
#define					TEXT2				0x1
#define					TEXT3				0x2
//------------------------------------------------------------------------------------------------------
// Text High Color(32768/65536) enable/disable
//------------------------------------------------------------------------------------------------------
#define 				Text_RGBDisable		0x0
#define 				Text_RGBEnable		0x1
//------------------------------------------------------------------------------------------------------
// Text Blending enable/disable
//------------------------------------------------------------------------------------------------------
#define					Text_BlendDisable	0x0
#define					Text_BlendEnable	0x1
//------------------------------------------------------------------------------------------------------
// Sprite Blending enable/disable
//------------------------------------------------------------------------------------------------------
#define					Sp_BlendDisable 	0x0
#define					Sp_BlendEnable		0x1
//------------------------------------------------------------------------------------------------------
// Text Horizontal Movement enable/disable
//------------------------------------------------------------------------------------------------------
#define					Hv_Disable			0x0
#define					Hv_Enable			0x1
//------------------------------------------------------------------------------------------------------
//	Text Effect Mode Define
//------------------------------------------------------------------------------------------------------
#define					WALLPAPER			0
#define					HOFFSET				1
#define					BLEND				2
#define					FLIP				3
//------------------------------------------------------------------------------------------------------
// H-Compression Data for Same/ Different mode
//------------------------------------------------------------------------------------------------------
#define					LINES_SAME			0
#define					LINES_DIFFERENT		1
//------------------------------------------------------------------------------------------------------
// Enable/Disable define
//------------------------------------------------------------------------------------------------------
#define					DISABLE				0
#define					ENABLE				1	
//------------------------------------------------------------------------------------------------------
// Scrolling direction define
//------------------------------------------------------------------------------------------------------
#define					SCROLLING_LEFT		0
#define					SCROLLING_RIGHT		1
#define					SCROLLING_UP		2
#define					SCROLLING_DOWN		3
//------------------------------------------------------------------------------------------------------
// Palette Ram/Buff mode define
//------------------------------------------------------------------------------------------------------
#define					PALETTE_RAM			0
#define					PALETTE_BUFF		1	
//------------------------------------------------------------------------------------------------------
// TV System Mode Define
//------------------------------------------------------------------------------------------------------
#define					NTSC				1
#define					PAL 				4
#define 				NTSC_M      		0
#define 				NTSC_J      		1
#define 				NTSC_N    			2
#define 				PAL_M       		3
#define 				PAL_B       		4
#define 				PAL_N      			5
#define 				PAL_Nc      		6
//------------------------------------------------------------------------------------------------------
// Define Palette RAM Bank
//------------------------------------------------------------------------------------------------------
#define					PALETTE_RAMBANK0	0	
#define					PALETTE_RAMBANK1	1	
#define					PALETTE_RAMBANK2	2	
#define					PALETTE_RAMBANK3	3
//------------------------------------------------------------------------------------------------------
// Define Text/Sprite Palette Select
//------------------------------------------------------------------------------------------------------
#define					TEXT_PALETTE0		0	
#define					SPRITE_PALETTE0		1	
#define					TEXT_PALETTE1		2	
#define					SPRITE_PALETTE1		3
//------------------------------------------------------------------------------------------------------
// Define PPU Control Flag
//------------------------------------------------------------------------------------------------------
#define					PPU_DISABLE			0	
#define					PPU_ENABLE			1
#define					TEXT_RELATED		0	
#define					TEXT_DIRECT			1
#define					TEXT_TOP2BOT		0	
#define					TEXT_BOT2TOP		1
#define					VGA_DISABLE			0	
#define					VGA_ENABLE			1
#define					VGA_INTERLACE		0	
#define					VGA_NON_INTERLACE	1
#define					FREE_DISABLE		0	
#define					FREE_ENABLE			1
#define					TV_INTERLACE		0	
#define					TV_NON_INTERLACE	1
//------------------------------------------------------------------------------------------------------
// Define Text/Sprite Flip Flag
//------------------------------------------------------------------------------------------------------
#define					NO_FLIP				0	
#define					H_FLIP				1
#define					V_FLIP				2	
#define					HV_FLIP				3
//------------------------------------------------------------------------------------------------------
// Define Sprite Control Flag
//------------------------------------------------------------------------------------------------------
#define					SP_DISABLE			0	
#define					SP_ENABLE			1
#define					SP_COORD1			0	
#define					SP_COORD2			1
#define					SP_NOROUND			0	
#define					SP_ROUND			1
#define					SP_RELATED			0	
#define					SP_DIRECT			1
//------------------------------------------------------------------------------------------------------
// Define Sprite Effect Flag
//------------------------------------------------------------------------------------------------------
#define					SP_MOSAIC			0	
#define					SP_ROTATE			1	
#define					SP_ZOOM				2
//------------------------------------------------------------------------------------------------------
// Define Palette Type
//------------------------------------------------------------------------------------------------------
#define					PALETTE16_SHARE		0	
#define					PALETTE16_SEPARATE	1 
#define					PALETTE25_SHARE		2	
#define					PALETTE25_SEPARATE	3
//------------------------------------------------------------------------------------------------------
// Define Text Working Mode
//------------------------------------------------------------------------------------------------------
#define					MODE_2D				0	
#define					MODE_HCMP			1 
#define					MODE_VCMP			2	
#define					MODE_HVCMP			3
//------------------------------------------------------------------------------------------------------
// Define 4/64-Level Blend Mode
//------------------------------------------------------------------------------------------------------
#define					BLEND4				0	
#define					BLEND64				1 
//------------------------------------------------------------------------------------------------------
// Define The Size of Text Layer
//------------------------------------------------------------------------------------------------------
#define					TEXT_512x256		0	
#define					TEXT_512x512		1
#define					TEXT_1024x512		2
#define					TEXT_1024x1024		3
//------------------------------------------------------------------------------------------------------
// Define Frame Base Mode Disable/Enable
//------------------------------------------------------------------------------------------------------
#define					LINE_BASE		    0 
#define					RGB565			    0 
#define					RGBG				1  
#define					BPP_16			    0 
#define					BPP_1				1 
#define					BPP_2				2 
#define					BPP_4				3 
//------------------------------------------------------------------------------------------------------
// Define I-Cache Size
//------------------------------------------------------------------------------------------------------
#define					CACHE_8			    0 
#define					CACHE_1K			1  
#define					CACHE_2K		    2
#define					CACHE_4K			3  
//------------------------------------------------------------------------------------------------------
// Define Page memory CS/Size/Wait cycle
//------------------------------------------------------------------------------------------------------
#define					MCS0			    0 
#define					MCS1			    1  
#define					MCS2		        2
#define					MCS3	    		3  
#define					MCS4	    		4
#define					PageSize1		    0 
#define					PageSize4		    1  
#define					PageSize8	        2
#define					PageSize16    		3  
#define					WaitCycle1	    	1
#define					WaitCycle2	    	2
#define					WaitCycle3	    	3
#define					WaitCycle4	    	4
#define					WaitCycle5	    	5
#define					WaitCycle6	    	6
#define					WaitCycle7	    	7
#define					WaitCycle8	    	8
//------------------------------------------------------------------------------------------------------
// Define Palette RAM Bank
//------------------------------------------------------------------------------------------------------
#define					PaletteBank0		0
#define					PaletteBank1		1
//------------------------------------------------------------------------------------------------------
// Define Sprite Working Mode
//------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------
// Define Pixel Bit In Frame Base Mode
//------------------------------------------------------------------------------------------------------
#define					Pixel16Bit			0
#define					Pixel1Bit			1
#define					Pixel2Bit			2
#define					Pixel4Bit			3

//------------------------------------------------------------------------------------------------------
// Define TEXT Char 0 Auto Transparent Mode
//------------------------------------------------------------------------------------------------------
#define					TextChar0AutoTransparent_Enable			1
#define					TextChar0AutoTransparent_Disable		0

//======================================================================================================
//	External Global Variables Area 
//======================================================================================================
extern	int 			Text1IndexTable[];	//Text1 index table (number array)		
extern	int 			Text2IndexTable[];	//Text2 index table (number array)	
extern	int 			Text3IndexTable[];	//Text3 index table (number array)	
extern	int 			Text1AttrTable[];	//Text1 attribute table (attribute array)	
extern	int 			Text2AttrTable[]; //Text2 attribute table (attribute array)
extern	int 			Text3AttrTable[]; //Text3 attribute table (attribute array)
extern	SPRITE			Sprite_Buff[];	//Sprite structure
extern	int				SpriteBuf0[];	//Sprite buffer 0
extern	int				SpriteBuf1[];	//Sprite buffer 1
extern	int				spriteFlag;	//Sprite data update flag
extern	int				textScroll; //Text scrolling flag
extern	int 			text1_x, text1_y, text2_x, text2_y, text3_x, text3_y;	//Text scrolling position 
extern	int             TextModeFlag; //Text mode update flag
extern	int				Text1Mode, Text2Mode, Text3Mode; //Text mode value
extern	U32             ptrTxPalette0, ptrTxPalette1, ptrSpPalette0, ptrSpPalette1;
extern	int             HoffsetBuff[240];	//Horizontal offset buffer
extern	int 			TxPaletteFlag0;	//Text palette 0 update flag
extern	int 			SpPaletteFlag0;	//Sprite palette 0 update flag
extern	int 			TxPaletteFlag1;	//Text palette 1 update flag
extern	int 			SpPaletteFlag1;	//Sprite palette 1 update flag
extern	int             HoffsetFlag;	//Horizontal offset update flag
extern	int				HCmpFlag;	//Horizontal compression update flag
extern	int				LineMode;	//Line mode value
extern	int 			HCmpValue;	//Horizontal compression value
extern	U32				ptrHCmpTable;	//Horizontal compression data pointer
extern	int				VCmpFlag;	//Vertical compression update flag
extern	int				VCmpValue;	//Vertical compression value
extern	int				VCmpOffset;	//Vertical compression offset value
extern	int				VCmpStep;	//Vertical compression step value
extern	int             Text3OffsetX;	//Text3 X offset value
extern	int             Text3OffsetY;	//Text3 Y offset value
extern	int             Text4OffsetX;	//Text4 X offset value
extern	int             Text4OffsetY;	//Text4 Y offset value
extern	U16 			old_game_time, game_time; //game time
extern	int             Scrolling_H1, Scrolling_V1;	//Text1 horizontal/vertical start character
extern	int             Scrolling_H2, Scrolling_V2;	//Text2 horizontal/vertical start character
extern	int             Scrolling_H3, Scrolling_V3;	//Text3 horizontal/vertical start character
extern	int             Scrolling_H4, Scrolling_V4;	//Text4 horizontal/vertical start character			
extern	int 			iHoffsetCount;	//counter for Sea offset
extern	int 			fb_switch;	//frame buffer switch flag 
extern	int				ppu_flag, tv_flag;	//PPU/TV active flag
extern	U16				ppu_count;	//PPU frame counter	
extern  int				FadeInFlag, FadeOutFlag;	//Fade in/out flag
extern  U16             FadePeriod;	//frame interval for fade effect
extern  int				cpu_done; //CPU done flag for frame base mode
extern  U16             FadeCount; //Frame counter of fade effect
extern  int				text1_index_length;
extern  int				text2_index_length;
extern  int				text3_index_length;
extern  int				sp_number_max;

//======================================================================================================
// Macro Definition Area 
//======================================================================================================
//======================================================================================================
//	Description:	Set CPU IRQ on
//	Function:		SetCpuIrqON()
//	Syntax:			SetCpuIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//======================================================================================================
#define		SetCpuIrqON()                                       \
            asm(                                                \
                    "IRQ    on\n"                               \
               );

//======================================================================================================
//	Description:	Set CPU IRQ on
//	Function:		SetCpuIrqON()
//	Syntax:			SetCpuIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//======================================================================================================
#define		SetCpuIrqOFF()                                       \
            asm(                                                \
                    "IRQ    off\n"                               \
               );

//======================================================================================================
//	External Function Area 
//======================================================================================================
//====================================================================================================
//	Description:	Get 32-bit long address from PPU resource address table
//	Function:		GetLongAddress()
//	Syntax:			U32	GetLongAddress(int index);
//	Input Paramter:	int index: The index of PPU resource address table
//	Return: 		32-bit long address 			
//====================================================================================================
extern unsigned long GetLongAddress(int index);

//====================================================================================================
//	Description:	Set the value to memory
//	Function:		MyMemSet()
//	Syntax:			void	MyMemSet(U32 DestMem, S16 value, U32 num);
//	Input Paramter:	U32 DestMem : Start address of target memory
//					S16 Value: Data value	
//					U32 Num: Data number to write to memory (words)
//	Return: 		None			
//====================================================================================================
void	MyMemSet(U32 DestMem, S16 Value, U32 Num);  

//================================================================================
//	Description:	Use DMA channel 0 to transfer data
//	Function:		SetDMACopy0()
//	Syntax:			void	SetDMACopy0(U32 SrcMem, U32 DestMem, U32 Num);
//	Input Paramter:	U32 SrcMem: Start address of source memory
//					U32 DestMem: Start address of target memory
//					U32 Num: DMA Transfer data number (words)
//	Return: 		none
//  Note:	After transferring one data, both source and destination address will increase one.
//================================================================================
void	SetDMACopy0(U32 SrcMem, U32 DestMem, U32 Num);
                           
//====================================================================================================
//	Description:	Set color palette by manual data (all same data)
//	Function:		SetColorPalette()
//	Syntax:			void	SetColorPalette(int col_st, int col_end, int value, int pal_sel);
//	Input Paramter:	int col_st:		Palette start index address
//					int col_end:	Palette end index address
//					int value:		Palette data value
//                  int pal_sel:    Palette selection
//									0: Text Palette 0
//									1: Sprite Palette 0 
//   								2: Text Palette 1
//   								3: Sprite Palette 1
//	Return: 		none
//  Note: 			The new palette data will be updated to palette RAM directly.
//====================================================================================================
void	SetColorPalette(int col_st, int col_end, int value, int pal_sel);

//====================================================================================================
//	Description:	Write color palette data to palette RAM
//	Function:		WriteColorPalette()
//	Syntax:			void	WriteColorPalette(void);
//	Input Paramter:	none
//	Return: 		none
//	Note:			The new palette data will be updated from buffer to palette RAM.
//====================================================================================================
void	WriteColorPalette(void);

//====================================================================================================
//	Description:	Set one palette color to be transparent
//	Function:		SetOneTransparentColor()
//	Syntax:			void	SetOneTransparentColor(int pal_index, int value, int pal_sel);
//	Input Paramter:	int pal_index:	palette index address
//					int value:	0: clear transparent 
//								1: set transparent
//                  int pal_sel:    Palette selection (0~3)
//									0: Text Palette 0
//									1: Sprite Palette 0 
//   								2: Text Palette 1
//   								3: Sprite Palette 1
//	Return: 		none
//	Note:			The transparent setting will be updated to palette RAM directly.
//====================================================================================================
void	SetOneTransparentColor(int pal_index, int value, int pal_sel);

//====================================================================================================
//	Description:	Set one block of palette colors to be transparent
//	Function:		SetTransparentColor()
//	Syntax:			void	SetTransparentColor(int col_st, int col_end, int value, int pal_sel);
//	Input Paramter:	int col_st:		palette start index address
//					int col_end:	palette end index address
//					int value:		0: clear transparent 
//									1: set transparent
//                  int pal_sel:    Palette selection (0~3)
//									0: Text Palette 0
//									1: Sprite Palette 0 
//   								2: Text Palette 1
//   								3: Sprite Palette 1		
//	Return: 		none
//	Note:			The transparent setting will be updated to palette RAM directly.
//====================================================================================================
void	SetTransparentColor(int col_st, int col_end, int value, int pal_sel);

//====================================================================================================
//	Description:	Set all palette color to be transparent
//	Function:		SetAllTransparent()
//	Syntax:			void	SetAllTransparent(int value, int pal_sel);
//	Input Paramter:	int value:	0: clear transparent 
//								1: set transparent
//					int pal_sel:    Palette selection (0~3)
//									0: Text Palette 0
//									1: Sprite Palette 0 
//   								2: Text Palette 1
//   								3: Sprite Palette 1				
//	Return: 		none
//====================================================================================================
void	SetAllTransparent(int value, int pal_sel);

//====================================================================================================
//	Description:	Clear one sprite data  
//	Function:		ClearOneSprite()
//	Syntax:			void	ClearOneSprite(int Spno);
//	Input Paramter:	int Spno:	Sprite number 
//	Return: 		none
//====================================================================================================
void	ClearOneSprite(int Spno);

//====================================================================================================
//	Description:	Clear all sprite data  
//	Function:		ClearAllSprite()
//	Syntax:			void	ClearAllSprite(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearAllSprite(void);

//====================================================================================================
//	Description:	Clear text register values
//	Function:		ClearTextRegister()
//	Syntax:			void	ClearTextRegister(int txn);
//	Input Paramter:	int txn: Text selection (0~3)
//							0: Text1
//							1: Text2
//							2: Text3
//							3: text4
//	Return: 		none
//====================================================================================================
void	ClearTextRegister(int txn);

//====================================================================================================
//	Description:	Clear Internal SRAM (28KW, 0 ~ 0x6FFF)
//	Function:		ClearAllRam()
//	Syntax:			void	ClearAllRam(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearAllRam(void);

//====================================================================================================
//	Description:	Clear PPU's buffer and initialize variables
//	Function:		ClearSimple()
//	Syntax:			void	ClearSimple(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearSimple(void);

//====================================================================================================
//	Description:	Clear all PPU registers/RAM and API's variable values
//	Function:		ClearAllSetting()
//	Syntax:			void	ClearAllSetting(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearAllSetting(void);

//====================================================================================================
//	Description:	Enable V-Blanking interrupt
//	Function:		VblankIrqON()
//	Syntax:			void	VblankIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	VblankIrqON(void);

//====================================================================================================
//	Description:	Disable V-Blanking interrupt
//	Function:		VblankIrqOFF()
//	Syntax:			void	VblankIrqOFF(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	VblankIrqOFF(void);


//====================================================================================================
//	Description:	Enable Sprite DMA transfer end interrupt
//	Function:		SpDMAIrqON()
//	Syntax:			void	SpDMAIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	SpDMAIrqON(void);

//====================================================================================================
//	Description:	Disable Sprite DMA transfer end interrupt
//	Function:		SpDMAIrqOFF()
//	Syntax:			void	SpDMAIrqOFF(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	SpDMAIrqOFF(void);

//====================================================================================================
//	Description:	Enable palette write error interrupt
//	Function:		PaletteErrIrqON()
//	Syntax:			void	PaletteErrIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	PaletteErrIrqON(void);

//====================================================================================================
//	Description:	Disable palette write error interrupt
//	Function:		PaletteErrIrqOFF()
//	Syntax:			void	PaletteErrIrqOFF(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	PaletteErrIrqOFF(void);

//====================================================================================================
//	Description:	Enable text under run interrupt
//	Function:		TxUnderRunIrqON()
//	Syntax:			void	TxUnderRunIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	TxUnderRunIrqON(void);

//====================================================================================================
//	Description:	Disable text under run interrupt
//	Function:		TxUnderRunIrqOFF()
//	Syntax:			void	TxUnderRunIrqOFF(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	TxUnderRunIrqOFF(void);

//====================================================================================================
//	Description:	Enable sprite under run interrupt
//	Function:		SpUnderRunIrqON()
//	Syntax:			void	SpUnderRunIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	SpUnderRunIrqON(void);

//====================================================================================================
//	Description:	Disable sprite under run interrupt
//	Function:		SpUnderRunIrqOFF()
//	Syntax:			void	SpUnderRunIrqOFF(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	SpUnderRunIrqOFF(void);

//====================================================================================================
//	Description:	Enable frame FIFO under run interrupt
//	Function:		FrameUnderRunIrqON()
//	Syntax:			void	FrameUnderRunIrqON(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	FrameUnderRunIrqON(void);

//====================================================================================================
//	Description:	Disable frame FIFO under run interrupt
//	Function:		FrameUnderRunIrqOFF()
//	Syntax:			void	FrameUnderRunIrqOFF(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	FrameUnderRunIrqOFF(void);

//====================================================================================================
//	Description:	Clear V-Blanking interrupt status
//	Function:		ClearVblankIRQ()
//	Syntax:			void	ClearVblankIRQ(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearVblankIRQ(void);

//====================================================================================================
//	Description:	Clear sprite DMA transfer end interrupt Status
//	Function:		ClearSpDMAIRQ()
//	Syntax:			void	ClearSpDMAIRQ(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearSpDMAIRQ(void);

//====================================================================================================
//	Description:	Clear palette write error interrupt Status
//	Function:		ClearPaletteErrIRQ()
//	Syntax:			void	ClearPaletteErrIRQ(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearPaletteErrIRQ(void);

//====================================================================================================
//	Description:	Clear text under run interrupt Status
//	Function:		ClearTxUnderRunIRQ()
//	Syntax:			void	ClearTxUnderRunIRQ(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearTxUnderRunIRQ(void);

//====================================================================================================
//	Description:	Clear sprite under run interrupt Status
//	Function:		ClearSpUnderRunIRQ()
//	Syntax:			void	ClearSpUnderRunIRQ(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ClearSpUnderRunIRQ(void);

//====================================================================================================
//	Description:	Initial PPU system control
//	Function:		InitPPU()
//	Syntax:			void	InitPPU(int ppu_en, int tx_direct, int tx_botup, int vga_en, int vga_nonintl, int free, int fb_en, int fb_format, int sp_25d, int fb_mono);
//	Input Paramter:	int ppu_en:
//								0:PPU_DISABLE
//								1:PPU_ENABLE
//					int tx_direct:
//								0:TEXT_RELATED
//								1:TEXT_DIRECT
// 					int tx_botup:
//								0:TEXT_TOP2BOT
//								1:TEXT_BOT2TOP
//					int vga_en:
//								0:VGA_DISABLE		
//								1:NA
//					int vga_nonintl:
//								0:VGA_INTERLACE
//								1:VGA_NON_INTERLACE
//					int free:
//								0:FREE_DISABLE (Max. 22-bit address mode)
//								1:FREE_ENABLE (Max. 27-bit address mode)
//					int fb_en:
//								0:LINE_BASE
//								1:NA
//					int fb_format:
//								0:RGB565
//								1:RGBG
//					int sp_25d:
//								0:SP2D_MODE
//								1:NA
//					int fb_mono:
//								0:16bpp
//								1:1bpp
//								2:2bpp
//								3:4bpp			
//	Return: 		none
//====================================================================================================
void	InitPPU(int ppu_en, int tx_direct, int tx_botup, int vga_en, int vga_nonintl, int free, int fb_en, int fb_format, int sp_25d, int fb_mono);

//====================================================================================================
//	Description:	Turn on PPU
//	Function:		ppu_on()
//	Syntax:			void	ppu_on(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ppu_on(void);

//====================================================================================================
//	Description:	Turn off PPU
//	Function:		ppu_off()
//	Syntax:			void	ppu_off(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	ppu_off(void);

//====================================================================================================
//	Description:	Wait Vertical blanking 
//	Function:		WaitBlanking()
//	Syntax:			void	WaitBlanking(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	WaitBlanking(void);

//====================================================================================================
//	Description:	Wait Vertical blanking IRQ
//	Function:		WaitBlanking2()
//	Syntax:			void	WaitBlanking2(void);
//	Input Paramter:	none
//	Return: 		none
//====================================================================================================
void	WaitBlanking2(void);

//====================================================================================================
//	Description:	Set Text Position
//	Function:		SetTextPosition()
//	Syntax:			void	SetTextPosition(int text, int x, int y);
//	Input Paramter:	int text: 	TEXT selection (0~3)
//								0:Text1
//								1:Text2
//								2:Text3
//								3:Text4
//					int x:	x position
//					int y:	y position
//	Return: 		none
//	Note:			New Text position will be updated to register at v-blanking IRQ. 
//====================================================================================================
void	SetTextPosition( int text, int x, int y );

//====================================================================================================
//	Description:	Screen fade out from original palette to black
//	Function:		Screen_Fade_Out()
//	Syntax:			int	Screen_Fade_Out(int n);
//	Input Paramter:	int n: Frame interval (n > 0)
//	Return: 		0:fade out process isn't completed
//					1:fade out process is completed 
//  Note:			Execute fade out once every n frame till the screen is become black.
//					Return "1" when the screen is faded out to black completely. 
//====================================================================================================
int		Screen_Fade_Out(int n);

//====================================================================================================
//	Description:	Screen fade in from black to original palette
//	Function:		Screen_Fade_In()
//	Syntax:			int	Screen_Fade_In(int n);
//	Input Paramter:	int n: Frame interval (n > 0)
//	Return: 		0:fade in process isn't completed
//					1:fade in process is completed 
//  Note:			Execute fade in once every n frame till the screen is recovered to original palette.
//					Return "1" when the screen is faded in to original palette completely. 
//====================================================================================================
int		Screen_Fade_In(int n);

//====================================================================================================
//	Description:	Check Two Sprite x,y Position Hit
//	Function:		Sprite_Hit_Chk()
//	Syntax:			int		Sprite_Hit_Chk(int Main_Index, int Enemy_Index);
//	Input Paramter:	int Main_Index:		SpriteBuf Index 1 (0~255)
//					int Enemy_Index:	SpriteBuf Index 2 (0~255)
//	Return: 		0:					no hit
//					1:					hit
//====================================================================================================
int		Sprite_Hit_Chk(int Main_Index, int Enemy_Index);

//====================================================================================================
//	Description:	Text layer every scanline Horizontal Movement
//	Function:		HorizontalMovement()
//	Syntax:			void	HorizontalMovement(int StartScanline,int EndScanline,U32 lpScanline);
//	Input Paramter:	int StartScanline:	Start Scanline (0~239)
//					int EndScanline:	End Scanline (0~239)
//					U32 lpScanline:	Scanline Movement data table
//	Return: 		none
//  Note:			Horizontal movement value will be updated from buffer to register at v-blanking IRQ. 
//====================================================================================================
void	HorizontalMovement(int StartScanline, int EndScanline, U32 lpScanline);

//====================================================================================================
//	Description:	PPU Service function
//	Function:		PPU_Service()
//	Syntax:			void	PPU_Service(void);
//	Input Paramter:	none
//	Return: 		none
//	NOTE:			PPU service routine to update PPU registers and SRAM.
//====================================================================================================
void	PPU_Service(void);

//====================================================================================================
//	Description:	Set text effect
//	Function:		SetTextEffect()
//	Syntax:			void	SetTextEffect(int nText,int nMode,int nEnable);
//	Input Paramter:	int nText: 	Text selection (0~2)
//								0:TEXT1		
//								1:TEXT2		
// 								2:TEXT3
//					int nMode:	Text effect selection (0~3)
//								0:WALLPAPER		
//								1:HOFFSET
//								2:BLEND
//								3:FLIP
//					nEnable:	Effect enable (0~3)
//								0:DISABLE
//								1:ENABLE
//					(Flip Mode):
//								0:NO_FLIP
//								1:H_FLIP
//								2:V_FLIP
//								3:HV_FLIP
//	Return: 		none
//====================================================================================================
void	SetTextEffect(int nText,int nMode,int nEnable);

//====================================================================================================
//	Description:	Set text blend mode 
//	Function:		SetTxBlendMode()
//	Syntax:			void	SetTxBlendMode(int nText, int mode);
//	Input Paramter:	int nText: 	Text selection (0~2)
//								0:TEXT1		
//								1:TEXT2		
// 								2:TEXT3
//					int	mode:	Mode selection (0~1) 
//								0:4-level blending mode
//								1:64-level blending mode
//	Return: 		none
//====================================================================================================
void	SetTxBlendMode(int nText, int mode);

//====================================================================================================
//	Description:	Set 4-level blending level 
//	Function:		SetBlendLevel4()
//	Syntax:			void	SetBlendLevel4(int nBlendLevel);
//	Input Paramter:	int	nBlendLevel: Blending level (0~3)
//	Return: 		none
//====================================================================================================
void	SetBlendLevel4(int nBlendLevel);

//====================================================================================================
//	Description:	Set text 64-level blending level 
//	Function:		SetTxBlendLevel64()
//	Syntax:			void	SetTxBlendLevel64(int nText, int nBlendLevel);
//	Input Paramter:	int nText: 	Text selection (0~2)
//								0:TEXT1		
//								1:TEXT2		
// 								2:TEXT3
//					int	nBlendLevel: Blending level (0~63)	
//	Return: 		none
//====================================================================================================
void	SetTxBlendLevel64(int nText, int nBlendLevel);

//====================================================================================================
//	Description:	Set Horizontal compression value
//	Function:		HCompressEffect()
//	Syntax:			void	HCompressEffect(int nMode,int nCompValue,U32 ptrCmpTable);
//	Input Paramter:	int	nMode: Mode selection (0~1)
//							   0:LINES_SAME
//							   1:LINES_DIFFERENT		
//					int nCompValue:	Horizontal compression value (1~128)
//					U32 ptrCmpTable: Horizontal compression value table address
//	Return: 		none
//	Notes:			If compress every line with the same value, just write value to nCompValue.
//					If compress every line with the different value, you need to set up one value table.
//					Horizontal compression effect is available only for Text1.
//====================================================================================================
void	HCompressEffect(int nMode, int nCompValue, U32 ptrCmpTable);

//====================================================================================================
//	Description:	Set vertical compression value
//	Function:		VCompressEffect()
//	Syntax:			void	VCompressEffect(int nCompValue,int nCompStep,int nCompOffset);
//	Input Paramter:	int nCompValue:   	vertical compression value
//					int nCompStep: 		vertical compression step value
//					int nCompOffset:	vertical compression offset value
//	Return: 		none
//	Note:			The compression value will be updated to register in Vblank interrupt. 
//====================================================================================================
void	VCompressEffect(int nCompValue,int nCompStep,int nCompOffset);

//====================================================================================================
//	Description:	Set horizontal movement value
//	Function:		HOffsetEffect()
//	Syntax:			void	HOffsetEffect(int nMode, int nMoveValue, U32 ptrMoveTable);
//	Input Paramter:	int	nMode: Mode selection (0~1)
//							   0:LINES_SAME
//							   1:LINES_DIFFERENT
//					int nMoveValue:	Horizontal movement value
//					U32 ptrMoveTable: Horizontal movement value table
//	Return: 		none
//	Notes:			If move every line with the same value,just write value to nMoveValue.
//					If move every line with the different value, you need to set up a value table.
//====================================================================================================
void	HOffsetEffect(int nMode, int nMoveValue, U32 ptrMoveTable);

//====================================================================================================
//	Description:	Horizontal movement effect 
//	Function:		Sea_Hoffset()
//	Syntax:			void	Sea_Hoffset(void);
//	Input Paramter:	none
//	Return: 		none
//	NOTES:			Horizontal movement as sea
//====================================================================================================
void	Sea_Hoffset(void);

//====================================================================================================
//	Description:	Text TextAttribInRAM_Initial Effect
//	Function:		TextAttribInRAM_Initial()
//	Syntax:			int	TextAttribInRAM_Initial(int nText, int nBld, int nFlip, int nPalette, int *ptAttSrc)
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3		
//					int nBld:  Blending mode
//							   0:Text_BlendDisable
//							   1:Text_BlendEnable	
//					int nFlip: Flip mode (0~3)
//									0:No Flip
//							   		1:H-Flip
//									2:V-Flip
//									3:HV-Flip
//					int nPalette: 4-bit palette selection (0~15)
//					int *ptAttSrc: attribute array pointer
//	Return: 		0:	Initial OK
//				   -1:  Initial Fail
//  Note:			Bitmap-mode text can't use this function.
//====================================================================================================
int TextAttribInRAM_Initial(int nText, int nBld, int nFlip, int nPalette, int *ptAttSrc);

//====================================================================================================
//	Description:	Text Flip Effect 
//	Function:		FlipEffect()
//	Syntax:			void	FlipEffect(int nText,int nFlipMode,int nSizeX,int nSizeY, int *FlipBuffer)
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3		
//					int nFlipMode: Flip mode (0~3)
//									0:No Flip
//							   		1:H-Flip
//									2:V-Flip
//									3:HV-Flip
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//	Return: 		none
//  Note:			Bitmap-mode text can't use this function.
//====================================================================================================
void	FlipEffect(int nText,int nFlipMode,int nSizeX,int nSizeY, int *FlipBuffer);

//====================================================================================================
//	Description:	Initial character-mode text
//	Function:		InitCharacter()
//	Syntax:			void	InitCharacter(int nText, U32 IdxTab, U32 AttrTab, int nCellX, int nCellY, int nSizeX, int nSizeY, int nTextSize, int nColorMode, int nDepth, int nPalette);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3	
//					U32 IdxTab: Character index data address
//					U32 AttrTab: Attribute data address
//					int nCellX: Horizontal character size (8/16/32/64)
//					int nCellY:	Vertical character size (8/16/32/64)
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//					int nTextSize: The size of text layer (0~3)
//								   0:512x256
//								   1:512x512
//								   2:1024x512
//								   3:1024x1024
//					int nColorMode:	Color mode (0~5)
//									0:4 color		
//									1:16 color		
//									2:64 color		
//									3:256 color
//									4:32768 color
//									5:65536 color				
//					int nDepth: Depth layer (0~3)		
//								0:Text Depth 0
//								1:Text Depth 2
//								2:Text Depth 4
//							    3:Text Depth 6
//					int nPalette: 4-bit palette selection (0~15)
//	Return: 		none
//====================================================================================================
void	InitCharacter(int nText,U32 IdxTab,U32 AttrTab,int nCellX,int nCellY,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette);

//====================================================================================================
//	Description:	Show Character text
//	Function:		fnShow_Chr()
//	Syntax:			void	fnShow_Chr(int nText,U32 IdxTab,U32 AttrTab,U32 CharData,int nCellX,int nCellY,int nSizeX,int nSizeY,int nTextSize,int nColor,int nDepth,int nPalette,int nPalBank);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3
//					U32 IdxTab: Character index data address
//					U32 AttrTab: Attribute data address
//					U32 CharData: Character data address
//					int nCellX: Horizontal character size (8/16/32/64)
//					int nCellY:	Vertical character size (8/16/32/64)
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//					int nTextSize: The size of text layer (0~3)
//								   0:512x256
//								   1:512x512
//								   2:1024x512
//								   3:1024x1024
//					int nColor:	Color mode (0~5)
//								0:4 color		
//								1:16 color		
//								2:64 color		
//								3:256 color
//								4:32768 color
//								5:65536 color		
//					int nDepth: Depth layer (0~3)		
//								0:Text Depth 0
//								1:Text Depth 2
//								2:Text Depth 4
//							    3:Text Depth 6
//					int nPalette: 4-bit palette selection (0~15)
//					int nPalBank: Text palette RAM bank (0~1) 
//	Return: 		none
//====================================================================================================
void	fnShow_Chr(int nText,U32 IdxTab,U32 AttrTab,U32 CharData,int nCellX,int nCellY,int nSizeX,int nSizeY,int nTextSize,int nColor,int nDepth,int nPalette,int nPalBank);

//====================================================================================================
//	Description:	Initial Bitmap text
//	Function:		InitBitmap()
//	Syntax:			void	InitBitmap(int nText,U32 bmpdata,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3
//					U32 bmpdata: bitmap data address
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//					int nTextSize: The size of text layer (0~3)
//								   0:512x256
//								   1:512x512
//								   2:1024x512
//								   3:1024x1024
//					int nColorMode:	Color mode (0~5)
//									0:4 color		
//									1:16 color		
//									2:64 color		
//									3:256 color
//									4:32768 color
//									5:65536 color		
//					int nDepth: Depth layer (0~3)		
//								0:Text Depth 0
//								1:Text Depth 2
//								2:Text Depth 4
//							    3:Text Depth 6
//					int nPalette: 4-bit palette selection (0~15)
//	Return: 		none
//	Note:			The bitmap special mode is applied only when horizontal size is 320/640/512/1024.
//					The bitmap special mode means that PPU hardware computes start address of each line automatically. 		
//====================================================================================================
void	InitBitmap(int nText,U32 bmpdata,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette);

//====================================================================================================
//	Description:	Show Bitmap text
//	Function:		fnShow_Bmp()
//	Syntax:			void	fnShow_Bmp(int nText, U32 bmpdata, int nSizeX, int nSizeY, int nTextSize, int nColorMode, int nDepth, int nPalette, int nAuto, int nPalBank);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3
//					U32 bmpdata: bitmap data address
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//					int nTextSize: The size of text layer (0~3)
//								   0:512x256
//								   1:512x512
//								   2:1024x512
//								   3:1024x1024
//					int nColorMode:	Color mode (0~5)
//									0:4 color		
//									1:16 color		
//									2:64 color		
//									3:256 color		
//									4:32768 color
//									5:65536 color		
//					int nDepth: Depth layer (0~3)		
//								0:Text Depth 0
//								1:Text Depth 2
//								2:Text Depth 4
//							    3:Text Depth 6
//					int nPalette: 4-bit palette selection (0~15)
//					int nPalBank: Text palette RAM bank (0~1) 
//	Return: 		none
//	Note:			The bitmap special mode is applied automatically only when horizontal size is 320/640/512/1024.
//					The bitmap special mode means that PPU hardware computes start address of each line automatically. 		
//====================================================================================================
void	fnShow_Bmp(int nText,U32 bmpdata,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette,int nPalBank);

//====================================================================================================
//	Description:	Initial palette
//	Function:		PaletteInitial()
//	Syntax:			void	PaletteInitial(int nMode, int nPalette, U32 PaletteData);
//	Input Paramter:	int nMode: Mode selection (0~1)	
//							   0:PALETTE_RAM
//							   1:PALETTE_BUFF
//					int nPalette: Palette selection (0~3)
//								  0: Text Palette 0
//								  1: Sprite Palette 0
//								  2: Text Palette 1
//								  3: Sprite Palette 1	
//					U32 PaletteData: Palette data address
//	Return: 		none
//====================================================================================================
void	PaletteInitial(int nMode, int nPalette, U32 PaletteData);

//====================================================================================================
//	Description:	Scrolling text (character mode)
//	Function:		ScrollingEffect()
//	Syntax:			void	ScrollingEffect(int nText,U32 IdxTab,int nHValue,int nVValue,int nSizeX,int nSizeY);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3
//					U32 IdxTab: Character index table address
//					int nHValue: Horizontal movement value
//								 nHValue > 0 : scrolling left 
//								 nHValue < 0 : scrolling right
//					int nVValue: Vertical movement value
//								 nHValue > 0 : scrolling up 
//								 nHValue < 0 : scrolling down
//					int nSizeX:	Real text size x
//					int nSizeY: Real text size y
//	Return: 		none
//	Note:			Bitmap-mode text can't use this function. 
//====================================================================================================
void	ScrollingEffect(int nText,U32 IdxTab,int nHValue,int nVValue,unsigned int nSizeX,unsigned int nSizeY);

//====================================================================================================
//	Description:	Set sprite control mode
//	Function:		SetSpriteCtrl()
//	Syntax:			void	SetSpriteCtrl(int spen, int coord, int round, int direct, int spnum);
//	Input Paramter:	int spen: Sprite layer enable (0~1)		
//							  0:Disable
//							  1:Enable
//					int coord: Sprite coordinate system (0~1) 
//							   0:Center Coordinate mode
//							   1:Left-top Coordinate mode
//					int round: Sprite round-robin mode enable (0~1)		
//							  0:Disable
//							  1:Enable
//					int direct: Sprite addressing mode (0~1)
//							  0:Related addressing mode
//							  1:Direct addressing mode
//					int spnum: Maximum available sprite number (1~256)		
//	Return: 		none
//====================================================================================================
void	SetSpriteCtrl(int spen, int coord, int round, int direct, int spnum);

//====================================================================================================
//	Description:	Set sprite effect
//	Function:		SetSpriteEffect()
//	Syntax:			void	SetSpriteEffect(int nMode, int nEnable);
//	Input Paramter:	int nMode: Sprite special effect selection (0~2)
//							   0:Mosaic effect
//							   1:Rotate effect
//							   2:Zoom effect
//					nEnable: Effect enable (0~1)
//							 0:Disable
//							 1:Enable
//	Return: 		none
//====================================================================================================
void	SetSpriteEffect(int nMode, int nEnable);

//====================================================================================================
//	Description:	Set sprite blend mode 
//	Function:		SetSpBlendMode()
//	Syntax:			void	SetSpBlendMode(int mode);
//	Input Paramter:	int	mode: Blending mode (0~1)
//							  0:4-level blending mode
//							  1:64-level blending mode
//	Return: 		none
//====================================================================================================
void	SetSpBlendMode(int mode);

//====================================================================================================
//	Description:	Set palette type
//	Function:		SetPaletteType()
//	Syntax:			void	SetPaletteType(int type);
//	Input Paramter:	int type: Palette type (0~3)
//							  0:PALETTE16_SHARE (Text and Sprite share the same 16-bit palette)
//							  1:PALETTE16_SEPARATE (Text and Sprite have the different 16-bit palette)
//							  2:PALETTE24_SHARE (Text and Sprite share the same 25-bit palette)
//							  3:PALETTE24_SEPARATE (Text and Sprite have the different 25-bit palette)
//	Return: 		none
//====================================================================================================
void	SetPaletteType(int type);

//====================================================================================================
//	Description:	Set palette ram bank
//	Function:		SetPaletteRamBank()
//	Syntax:			void	SetPaletteRamBank(int bank);
//	Input Paramter:	int bank: Bank value (0~3)
//	Return: 		none
//====================================================================================================
void	SetPaletteRamBank(int bank);

//====================================================================================================
//	Description:	Set text layer working mode
//	Function:		SetTextMode()
//	Syntax:			void	SetTextMode(int nText, int mode);
//	Input Paramter:	int nText: Text selection (0~3)
//							   0:TEXT1
//							   1:TEXT2
//							   2:TEXT3
//							   3:TEXT4
//					int mode: Woking mode (0~3)
//							  0: MODE_2D   			   (TEXT1/2/3/4)
//							  1: MODE_HCMP/MODE_ROTATE (TEXT1)/(TEXT3/4)
//							  2: MODE_VCMP/MODE_25D	   (TEXT1/TEXT2)/(TEXT3)
//							  3: MODE_HVCMP 		   (TEXT1)
//	Return: 		none
//====================================================================================================
void	SetTextMode(int nText, int mode);

//====================================================================================================
//	Description:	Set Sprite Position
//	Function:		SetSpritePosition()
//	Syntax:			void	SetSpritePosition(int nSpIdx, int x, int y, int scroll);
//	Input Paramter:	none
//					int nSpIdx:	Sprite index (0~255)
//					int x: X position increasement
//					int y: Y position increasement
//					int scroll: Sprite scroll enable (0~1)
//								0:Disable
//								1:Enable (when the sprite exceeds screen boundary, it will appear in opposite direction.) 
//	Return: 		none
//  Note:			The original is on top-left conner of text screen.  
//====================================================================================================
void	SetSpritePosition(int nSpIdx, int x, int y, int scroll);

//================================================================================
//	Description:	Sprite coordinate system conversion
//	Function:		SpCoordConvert()
//	Syntax:			void	SpCoordConvert(int nSpIdx, int *x, int *y);
//	Input Paramter:	nSpIdx: Sprite index (0~255)
//					*x: X position pointer
//					*y: Y position pointer
//	Return: 		none
//  Note:			Convert left-top coordinate to center coordinate.
//================================================================================		
void	SpCoordConvert(int nSpIdx, int *x, int *y);

//====================================================================================================
//	Description:	Initial sprite buffer and set sprite segment 
//	Function:		Init_Sprite()
//	Syntax:			void	Init_Sprite(U32 SpCharData);
//	Input Paramter:	U32 SpCharData: Sprite character data address
//	Return: 		none
//  Note:			After calling this function, please run "Paint_Sprite()" to show sprites.
//====================================================================================================
void	Init_Sprite(U32 SpCharData);

//====================================================================================================
//	Description:	Update sprite buffer  
//	Function:		Update_Sprite()
//	Syntax:			void	Init_Sprite(int nSpIdx);
//	Input Paramter:	nSpIdx: Sprite index (0~255)
//	Return: 		none
//  Note:			After calling this function, please run "Paint_Sprite()" to show sprites.
//====================================================================================================
void Update_Sprite(int nSpIdx);

//====================================================================================================
//	Description:	Show sprites on screen
//	Function:		Paint_Sprite()
//	Syntax:			void	Paint_Sprite();
//	Input Paramter:	none
//	Return: 		none
//  Note:			Before calling this function, please run "Init_Sprite()" once.
//====================================================================================================
void	Paint_Sprite();

//================================================================================
//	Description:	Set Sprite rotate level
//	Function:		SetSpRotate()
//	Syntax:			void	SetSpRotate(int nSpIdx, int nRotate);
//	Input Paramter:	int nSpIdx:	Sprite index (0~255)
//					int nRotate: Rotate level (0~63)
//	Return: 		none
//================================================================================
void	SetSpRotate(int nSpIdx, int nRotate);

//================================================================================
//	Description:	Set Sprite zoom level
//	Function:		SetSpZoom()
//	Syntax:			void	SetSpZoom(int nSpIdx, int nZoom);
//	Input Paramter:	int nSpIdx:	Sprite index (0~255)
//					int nZoom: Zoom level (0~63) 
//	Return: 		none
//================================================================================
void	SetSpZoom(int nSpIdx, int nZoom);

//================================================================================
//	Description:	Set Sprite Depth
//	Function:		SetSpDepth()
//	Syntax:			void	SetSpDepth(int nSpIdx, int nDepth);
//	Input Paramter:	int nSpIdx:	Sprite index (0~255)
//					int nDepth:	Depth (0~3)
//								0: Sprite depth 1
//								1: Sprite depth 3
//								2: Sprite depth 5
//								3: Sprite depth 7		 
//	Return: 		none
//================================================================================
void	SetSpDepth(int nSpIdx, int nDepth);

//================================================================================
//	Description:	Set Sprite Blending effect
//	Function:		SetSpBlend()
//	Syntax:			void	SetSpBlend(int nSpIdx, int nEnable);
//	Input Paramter:	int nSpIdx:	Sprite index (0~255)
//					int nEnable: Blend enable (0~1)
//								0:Disable
//								1:Enable
//	Return: 		none
//================================================================================
void	SetSpBlend(int nSpIdx, int nEnable);

//================================================================================
//	Description:	Set Sprite Mosaic Level
//	Function:		SetSpMosaic()
//	Syntax:			void	SetSpMosaic(int nSpIdx, int nMosaic);
//	Input Paramter:	int nSpIdx:	Sprite index (0~255)
//					int nMosaic: Mosaic level (0~3)
//								 0: No mosaic
//								 1: 2x2 mosaic
//								 2: 4x4 mosaic
//								 3: 8x8 mosaic
//	Return: 		none
//================================================================================
void	SetSpMosaic(int nSpIdx, int nMosaic);

//================================================================================
//	Description:	Set Sprite 64-level Blending Level
//	Function:		SetSpBlend64()
//	Syntax:			void	SetSpBlend64(int nSpIdx, int nBlend);
//	Input Paramter:	int nSpIdx:	Sprite index (0~255)
//					int nBlend:	Blend level (0~63)
//	Return: 		none
//================================================================================
void	SetSpBlend64(int nSpIdx, int nBlend);

//================================================================================
//	Description:	Set Sprite Flip effect
//	Function:		SetSpriteFlip()
//	Syntax:			void	SetSpriteFlip(int nSpIdx, int nFlip);
//	Input Paramter:	int nSpIdx: Sprite index (0~255)
//					int nFlip: Flip mode (0~3)
//							   0: NO_FLIP					
//							   1: H_FLIP
//							   2: V_FLIP
//							   3: HV_FLIP
//	Return: 		none
//================================================================================
void	SetSpriteFlip(int nSpIdx, int nFlip);

//================================================================================
//	Description:	Set Sprite 4-bit Palette selection
//	Function:		SetSpPaletteBank()
//	Syntax:			void	SetSpPaletteBank(int nSpIdx, int sel);
//	Input Paramter:	int nSpIdx: Sprite index (0~255)
//					int sel: Palette selection (0~15)						
//	Return: 		none
//================================================================================
void	SetSpPaletteBank(int nSpIdx, int sel);

//================================================================================
//	Description:	Clear CPU I-Cache
//	Function:		ClearICache()
//	Syntax:			void	ClearICache();
//	Input Paramter:	none		
//	Return: 		none
//================================================================================
void	ClearICache();

//================================================================================
//	Description:	Set CPU Instruction Cache
//	Function:		SetICache()
//	Syntax:			void	SetICache();
//	Input Paramter:	int size: Cache size (0~3) 	
//							  0:8 words 
//							  1:1k bytes  
//							  2:2k bytes
//							  3:4k bytes		
//	Return: 		none
//================================================================================
void	SetICache(int size);

//====================================================================================================
//	Description:	PPU Service function
//	Function:		PPU_Service()
//	Syntax:			void	PPU_Service(void);
//	Input Paramter:	none
//	Return: 		none
//	NOTE:			on IRQ0 write Sprite register, palette, Text move
//====================================================================================================
void	PPU_Service(void);

//================================================================================
//	Description:	PPU v-blanking interrupt service routine
//	Function:		VBLK_Service()
//	Syntax:			void	VBLK_Service();
//	Input Paramter:	none 	
//	Return: 		none
//================================================================================
void	VBLK_Service(void);


//====================================================================================================
//	Description:	Initial HVGA bitmap-mode text
//	Function:		InitBitmapHVGA()
//	Syntax:			void	InitBitmapHVGA(int nText,U32 bmpdata,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3
//					U32 bmpdata: bitmap data address
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//					int nTextSize: The size of text layer (0~3)
//								   0:512x256
//								   1:512x512
//								   2:1024x512
//								   3:1024x1024
//					int nColorMode:	Color mode (0~5)
//									0:4 color		
//									1:16 color		
//									2:64 color		
//									3:256 color
//									4:32768 color
//									5:65536 color		
//					int nDepth: Depth layer (0~3)		
//								0:Text Depth 0
//								1:Text Depth 2
//								2:Text Depth 4
//							    3:Text Depth 6
//					int nPalette: 4-bit palette selection (0~15)
//	Return: 		none
//====================================================================================================
void	InitBitmapHVGA(int nText,U32 bmpdata,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette);

//====================================================================================================
//	Description:	Show HVGA bitmap-mode text 
//	Function:		fnShow_Bmp_HVGA()
//	Syntax:			void	fnShow_Bmp_HVGA(int nText, U32 bmpdata, int nSizeX, int nSizeY, int nTextSize, int nColorMode, int nDepth, int nPalette, int nAuto, int nPalBank);
//	Input Paramter:	int nText: Text selection (0~2)
//							   0:TEXT1			
//							   1:TEXT2
//							   2:TEXT3
//					U32 bmpdata: bitmap data address
//					int nSizeX:	Real text size x
//					int nSizeY:	Real text size y
//					int nTextSize: The size of text layer (0~3)
//								   0:512x256
//								   1:512x512
//								   2:1024x512
//								   3:1024x1024
//					int nColorMode:	Color mode (0~5)
//									0:4 color		
//									1:16 color		
//									2:64 color		
//									3:256 color		
//									4:32768 color
//									5:65536 color		
//					int nDepth: Depth layer (0~3)		
//								0:Text Depth 0
//								1:Text Depth 2
//								2:Text Depth 4
//							    3:Text Depth 6
//					int nPalette: 4-bit palette selection (0~15)
//					int nPalBank: Text palette RAM bank (0~1) 
//	Return: 		none
//	Note:			The bitmap special mode is applied automatically only when horizontal size is 320/640/512/1024.
//					The bitmap special mode means that PPU hardware computes start address of each line automatically. 		
//====================================================================================================
void	fnShow_Bmp_HVGA(int nText,U32 bmpdata,int nSizeX,int nSizeY,int nTextSize,int nColorMode,int nDepth,int nPalette,int nPalBank);

//====================================================================================================
//	Description:	Get the address of resource file 
//	Function:		GetResAddress()
//	Syntax:			U32 GetResAddress(U16 *p);
//	Input Paramter:	U16 *p: The pointer of address table for resoure file 
//	Return: 		32-bit Long address 
//====================================================================================================
U32	GetResAddress(U16 *p);

//====================================================================================================
//	Description:	Init PPU Driver
//	Function:		InitPPUDrv()
//	Syntax:			S16 InitPPUDrv(U16 text1_index_length, U16 text2_index_length, U16 text3_index_length, U16 text4_index_length, U16 sp_number_max);
//	Input Paramter:	text1_index_length: Length of Number Array of Text1
//					text2_index_length: Length of Number Array of Text2
//					text3_index_length: Length of Number Array of Text3
//					sp_number_max: Max number of Sprite
//	Return: 		16-bit int
//====================================================================================================
S16 InitPPUDrv(U16 length1, U16 length2, U16 length3, U16 sp_no);

//====================================================================================================
//	Description:	Set TEXT Char 0 Auto Transparent Mode
//	Function:		SetTextChar0AutoTransparentMode
//	Syntax:			S16 SetTextChar0AutoTransparentMode(U16 auto_en);
//	Input Paramter:	auto_en: 
//							0:TextChar0AutoTransparent_Disable
//							1:TextChar0AutoTransparent_Enable
//	Return: 		16-bit int
//====================================================================================================
S16 SetTextChar0AutoTransparentMode(U16 auto_en);
#endif
