///////////////////////////////////////////////////////////////////////////////
// Topic:  resource arrange by manual.
// Description: The Programmer put some resource data that necessary be arranged address and via program manager 
//              to define all resource address.     
///////////////////////////////////////////////////////////////////////////////
.public     __PPUResourceTable
//=========================================================
// Data or Table resource definintion 
//=========================================================
PPU_ArrangeDATA:	.section	.data //,.addr=0x40000
//T_PPUExample:		.DW	10 DUP(?)
_Text1CharData:
.include	.\pattern\TEXT_Text1CellData.ach    
_Text1IndexData:
.include	.\pattern\TEXT_Text1CellIdx.atx    
_TextPaletteData:
.include	.\pattern\TEXT_Pal.apl 

_SpirteCharData:
.include	.\pattern\SpriteSP.ach
_SpritePaletteData:
.include	.\pattern\Sprite.apl

PPUResourceDATA:	.section	.data    ,.addr=0x1F000				//Resource Table must be within 0x200000 
__PPUResourceTable:
	.DW	offset _TEXT_Palette0,          seg16 _TEXT_Palette0		       //index = 0
	.DW	offset _TEXT_Palette1,          seg16 _TEXT_Palette1		       //index = 1
	.DW	offset _Text1IndexData,         seg16 _Text1IndexData		       //index = 2
	.DW	offset _Text1CharData,          seg16 _Text1CharData		       //index = 3
	
	.DW	offset _SpritePaletteData,      seg16 _SpritePaletteData		   //index = 4
	.DW	offset _SpirteCharData,         seg16 _SpirteCharData			   //index = 5
	
.include	Pattern\TEXT_Text1CellIdx.idx  								   //index = 6 (PicIndex 0)		
																																																			
	
SPU_ArrangeDATA:	.section 	.data		//,.addr=0x60000
//T_SPUExample:		.DW	10 DUP(?)


//=========================================================
// variable or RAM buffer definition
//=========================================================
PPU_ArrangeRAM:	.section	.ram	//,.addr=0x30000

SPU_ArrangeRAM:	.section 	.ram	//,.addr=0x40000



//=========================================================
// code section definition
//=========================================================
PPU_ArrangeCode:	.section	.code	//,.addr=0x70000

SPU_Arrangecode:	.section 	.code	//,.addr=0x80000