//
//	SPUDRV.H 
//	Edited and created by Porter@ CC SA in Generalplus Technology Co., Ltd.
//
//	2007-08-31 - Released as Standard Version V.7831
			

#ifndef	__SPUDRV_H__
#define	__SPUDRV_H__
//	write your header here

// Defined R_SPU_Status BITS, same as those defined in SPUDRV.ASM
#define	STS_MIDI_PLAY		0x0001	// SPU Status
#define STS_MIDI_CALLBACK	0x0100	// MIDI stop call back routine has been initiated
#define STS_MIDI_REPEAT_ON	0x0200	// MIDI play back continuously
#define STS_MIDI_PAUSE_ON	0x0400	// MIDI Pause flag
//#define STS_ADPCM_MODE_ON		0x0800	// ADPCM mode - 12 channels mode
//#define STS_NORMAL_MODE_ON	0x0000	// PCM mode - 16 channels mode


// Define MIDI playing mode here
#define SS_PLAYMIDI_ONCE	0x00	// Play MIDI SEQ once
#define SS_PLAYMIDI_INFINITY	0x01	// Play MIDI SEQ repeatly

//////////////////////////////////////////////////////////////////////
// SPU Initialization
// * HARDWARE DEPENDENT *
//	InitSPU(void);	Called from C  	
//	Input parameter : None
//	Return : SPU driver version(0x7831)
//////////////////////////////////////////////////////////////////////	
extern int InitSPU(void);	

//////////////////////////////////////////////////////////////////////
// SPU Stop
// * HARDWARE DEPENDENT *
//	StopSPU(void);	Called from C  	
//	Input parameter : None
//	Return : None
//////////////////////////////////////////////////////////////////////	
extern void StopSPU(void);	

//////////////////////////////////////////////////////////////////////////////////////////
//	MIDI playing channel MASK word
//	SetMidiChannelMask( unsigned short iMask_H, unsigned short iMask);
//	Input parameter : 
//			    iMask_H:	  Mask word for 8 channels, bits from B0 to B7 represent 	
//					  channel 16 to channel 23; When a bit equals 1 then the corresponding
//					  channel will be used by MIDI play algorithm, on the contrary bit equals
//					  to 0 then the corresponding channel will not be allocated for MIDI play
//					  User can reserve some channels for playing CELP or SPEECH			
//			    iMask:	  Mask word for 16 channels, bits from B0 to B15 represent 
//					  channel 0 to channel 15; When a bit equals 1 then the corresponding
//					  channel will be used by MIDI play algorithm, on the contrary bit equals
//					  to 0 then the corresponding channel will not be allocated for MIDI play
//					  User can reserve some channels for playing CELP or SPEECH			
//	Return : None
//////////////////////////////////////////////////////////////////////////////////////////
extern void SetMidiChannelMask( unsigned short iMask_H, unsigned short iMask);						


//////////////////////////////////////////////////////////////////////////////////////
// 	Play a specified MIDI sequence which is compiled from Tonemaker
// 	PlayMidi( iSeg, iOffset, iPlayMode);
// 	Input paramter : iSeg - Segment of sequence data which is compiled from Tonemaker
//  				iOffset - Offset of sequence data
//				    iPlayMode - SS_PLAYMIDI_ONCE | SS_PLAYMIDI_INFINITY
//					SS_PLAYMIDI_ONCE : Play MIDI once
//					SS_PLAYMIDI_INFINITY : Play MIDI repeatedly
//  Return : none
///////////////////////////////////////////////////////////////////////////////////////
extern void PlayMidi( unsigned short iSeg, unsigned short iOffset, short iPlayMode);

///////////////////////////////////////////////////////////////
// 	Stop MIDI playing back; 
//	StopMidi();
//	Input parameter : None
//  Return : None
///////////////////////////////////////////////////////////////
extern void StopMidi();

///////////////////////////////
//	Pause MIDI playing back 
//	PauseMidi();
//	Input parameter : none
//	Return : none
///////////////////////////////
extern void PauseMidi();

///////////////////////////////
//	Resume MIDI playing back 
//	PauseMidi();
//	Input parameter : none
//	Return : none
///////////////////////////////
extern void ResumeMidi();

//////////////////////////////////////
//  Adjust MIDI playing back volumn
//	SetMidiVolume( short iVolumn);
//	iVolumn : 0 .. 127 
//	Return : none		
//////////////////////////////////////
extern void SetMidiVolume( short iVolumn);

//////////////////////////////////////////////////////////////////////////////////////////
//	Setup and intitial the call back function of SPU driver while playing MIDI ends
//	InitMidiStopCallBackFunc( void* Func());
//  Input parameter : Near Pointer of Call back routine
//	Return : none
//////////////////////////////////////////////////////////////////////////////////////////
extern void InitMidiStopCallBackFunc( void *);

//////////////////////////////////////////////////////////////////////////////////////////
//	Stop the call back function of SPU driver while playing MIDI ends
//	DisableMidiStopCallBackFunc();
// 	Input parameter : none
//	Return : none
////////////////////////////////////////////////////////////////////////////////////////// 
extern void DisableMidiStopCallBackFunc();

////////////////////////////////////////////////////////////////////////////////////////////////////
//	Play a specified DRM file on a random available channel with 4 bits ADPCM or 8/16 bits PCM mode 
//	TM_PlayPCM( unsigned short iSeg, unsigned short iOffset,
//				unsigned short iPan, unsigned short iVelocity);
//
//	Input parameter : 	iSeg - Segment of specified DRM file
//						iOffset - Offset of specified DRM file
//						iPan - Balance value PAN
//						iVelocity - Amplitude of playing channel from 0 to maximum 127	
//	Appendix : PAN - PAN is the value of balance, when PAN equals zero that the playing sound
//				will only effect left speaker and on the contrary while PAN equals 127 then only 
//				right speaker will be effected. The MIDDLE is at 63 or 64;
//			   DRM - DRM is a file type of Sunplus polyphony system; It can support 8 bits PCM data,  
//					 16 bits PCM or 4 bits ADPCM data modes 
//	Return : Allocated channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////   			
extern int TM_PlayPCM( unsigned short iSeg, unsigned short iOffset, short iPan, short iVelocity);



////////////////////////////////////////////////////////////////////////////////////////////////////
//	Play a specified DRM file on a specified channel with 4 bits ADPCM or 8/16 bits PCM mode 
//	TM_PlayPCM_FixCH( unsigned short iChannelNo, unsigned short iSeg, unsigned short iOffset,
//				unsigned short iPan, unsigned short iVelocity);
//
//	Input parameter : 	iChannelNo - Specified channel for playing PCM/ADPCM 
//						iSeg - Segment of specified DRM file
//						iOffset - Offset of specified DRM file
//						iPan - Balance value PAN
//						iVelocity - Amplitude of playing channel from 0 to maximum 127	
//	Appendix : PAN - PAN is the value of balance, when PAN equals zero that the playing sound
//				will only effect left speaker and on the contrary while PAN equals 127 then only 
//				right speaker will be effected. The MIDDLE is at 63 or 64;
//			   DRM - DRM is a file type of Sunplus polyphony system; It can support 8 bits PCM data,  
//					 16 bits PCM or 4 bits ADPCM data modes 
//	Return : Playing channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////   			
extern int TM_PlayPCM_FixCH( unsigned short iChannelNo, unsigned short iSeg, unsigned short iOffset,
				unsigned short iPan, unsigned short iVelocity);

/////////////////////////////////////////////////////
//	Stop the specified channel
//	TM_StopPCM( unsigned short iChannel No);
//	Input parameter : The channel number from 0 to 23
//	Return : None
/////////////////////////////////////////////////////
extern void TM_StopPCM( short iChannelNo);

////////////////////////////////////////////////////////////////////////////////////////////////////
// Play a specified ALP file with variable Pitches and also PAN and velocity
// TM_PlayTone(   unsigned short PlayPitch
//				, unsigned short iSeg, unsigned short iOffset,
//				, unsigned short iPan, unsigned short iVelocity);
//	Input parameter : 	PlayPitch - Pitch number of playing note
//						iSeg - Segment of specified DRM file
//						iOffset - Offset of specified DRM file
//						iPan - Balance value PAN
//						iVelocity - Amplitude of playing channel from 0 to maximum 127	
//	Appendix : PAN - PAN is the value of balance, when PAN equals zero that the playing sound
//				will only effect left speaker and on the contrary while PAN equals 127 then only 
//				right speaker will be effected. The MIDDLE is at 63 or 64;
//			   ALP - ALP is a file type of Sunplus polyphony system; It can support 8 bits PCM data,  
//					 16 bits PCM or 4 bits ADPCM data modes and envelop data included  
//	Return : Playing channel number for this ALP file
/////////////////////////////////////////////////////////////////////////////////////////////////////
extern int TM_PlayTone(   unsigned short PlayPitch
						, unsigned short iSeg, 		unsigned short iOffset
						, unsigned short iPan, 		unsigned short iVelocity);
 
////////////////////////////////////////////////////////////////////////////////////////////////////
// Play a specified ALP file with variable Pitches and also PAN and velocity with specified channel
// TM_PlayTone_FixCH(   unsigned short iChannelNo, unsigned short PlayPitch
//				, unsigned short iSeg, unsigned short iOffset,
//				, unsigned short iPan, unsigned short iVelocity);
//	Input parameter : 	iChannelNo : Specified channel for playing note
//						PlayPitch - Pitch number of playing note
//						iSeg - Segment of specified DRM file
//						iOffset - Offset of specified DRM file
//						iPan - Balance value PAN
//						iVelocity - Amplitude of playing channel from 0 to maximum 127	
//	Appendix : PAN - PAN is the value of balance, when PAN equals zero that the playing sound
//				will only effect left speaker and on the contrary while PAN equals 127 then only 
//				right speaker will be effected. The MIDDLE is at 63 or 64;
//			   ALP - ALP is a file type of Sunplus polyphony system; It can support 8 bits PCM data,  
//					 16 bits PCM or 4 bits ADPCM data modes and envelop data included  
//	Return : Playing channel number for this ALP file
/////////////////////////////////////////////////////////////////////////////////////////////////////
extern void TM_PlayTone_FixCH(  unsigned short iChannelNo, unsigned short PlayPitch
								, unsigned short iSeg, 		unsigned short iOffset
								, unsigned short iPan, 		unsigned short iVelocity);
  

////////////////////////////////////////////////////////////////////////////////////
//	Get SPU status word
//	GetSPUStatus();
//	Input parameter : none
//	Return : SPU status word
//  Bit0 : 1 - MIDI is playing; 0 - MIDI stop
//	Bit1 : Reserved
//  Bit2 : Reserved
//  Bit3 : Reserved
//	Bit4 : Reserved
//  Bit5 : Reserved
//  Bit6 : Reserved
//  Bit7 : Reserved
//  Bit8 : 1 - MIDI ends event call back function has been initiated; 0 - None
//  Bit9 : 1 - Play the specified MIDI repeatedly; 0 - Play specified MIDI once
//  Bit10: 1 - MIDI pause on ; 0 - None    
//	Bit11 .. 15 - Reserved	
//
//  Defined constant label in ASM
//  	STS_MIDI_PLAY		0x0001
//  	STS_MIDI_CALLBACK	0x0100
//  	STS_MIDI_REPEAT_ON	0x0200
//  	STS_MIDI_PAUSE_ON	0x0400	

///////////////////////////////////////////////////////////////////////////////////////
extern unsigned short GetSPUStatus();

////////////////////////////////////////////////////////////////////////////////
//	Get the register word of channel status for Ch0 - Ch15
//	GetChannelStatus();
//	Input parameter : none
//  	Return : Status register word
//	Each bit in the return status register stand for one channel
//	--------------------------------------------------------------------------
//	ch15(B15) | ch14(B14) | ch13(B13) | ........ | ch2(B2) | ch1(B1) | ch0(B0) 		 
//	--------------------------------------------------------------------------
//	For all bits in register word : 1 - busy ; 0 - idle   
////////////////////////////////////////////////////////////////////////////////
extern unsigned short GetChannelStatus();
////////////////////////////////////////////////////////////////////////////////
//	Get the register word of channel status for Ch16 - Ch23
//	GetChannelStatus_H();
//	Input parameter : none
//  	Return : Status register word
//	Each bit in the return status register stand for one channel
//	--------------------------------------------------------------------------
//	ch23(B7) | ch22(B6) | ch21(B5) | ch20(B4) | ch19(B3) | ch18(B2) | ch17(B1) | ch16(B0) 		 
//	--------------------------------------------------------------------------
//	For all bits in register word : 1 - busy ; 0 - idle   
////////////////////////////////////////////////////////////////////////////////
extern unsigned short GetChannelStatus_H();
//////////////////////////////////////////////////////
//	Check if the specified channel is stopped or idle 
//	IsChannelStop( unsigned short iChannelNo); 
//	Input parameter : The channel number from 0 to 31
//	Return : 1 - The channel is idle or stopped
//			 0 - The channel is busy
//////////////////////////////////////////////////////
extern int IsChannelStop( unsigned short iChannelNo);	


//----------------------------------------------//
// Added by lzh (2004.12.23)
//-------------------------------------------------------------------------------//
//1.To set specific midi channel volume:
//> void SetMidiChVol(unsigned short iChannelNo, unsigned short iVolume);
//> Input parameter :iChannelNo: 0~31
//> 				 iVolume: 0~0x7F; 0x7F is max volume
//> Note: this function sets only the volume of a specific midi channel(), it is
//> also guide by the main midi volume.	
//-------------------------------------------------------------------------------//
extern	void	SetMidiChVol(unsigned short iChannelNo, unsigned short iVolume);


//-------------------------------------------------------------------------------//
//> 2. To reset specific midi channel volumes:
//> void ResetMidiChVol();
//> Note: this function resets all midi channel volumes to normal(0x7F).
//-------------------------------------------------------------------------------//
extern	void ResetMidiChVol();


///////////////////////////////////////////////////////////////////////////////////////////////////
//	_SetMidiMask:	Set Source MIDI Mask
//	Parameter:		unsigned int SourceMIDIMask:
//					Each bit of this vairable represets a source MIDI channel(the Source MIDI
//					here represents the midi before coverted by ToneMaker). If the bit is set
//					to 1, then the corresponding channel is unmasked, or else, the MIDI channel
//					is masked. The masked MIDI channel will not produce sound.
//	Return : 		None.
//	Notes:			This variable is reinitialized when calling the following function:
//					1:	InitSPU()
//					2:	StopMidi()
///////////////////////////////////////////////////////////////////////////////////////////////////
void SetMidiMask(unsigned int SourceMIDIMask);


///////////////////////////////////////////////////////////////////////////////////////////////////
//	Function:		SetMidiTempo();
//	Parameter:		MidiTempo:	MIDI Tempo value you want to set.
//	Return : 		None.
//	Notes:			Set MIDI tempo dynamicly
///////////////////////////////////////////////////////////////////////////////////////////////////
void SetMidiTempo(unsigned int TempoValue);


///////////////////////////////////////////////////////////////////////////////////////////////////
//	Function:		ResetMidiTempo();
//	Parameter:		None.
//	Return : 		None.
//	Notes:			Reset MIDI tempo to its initial state.
//					The MIDI tempo will be initialized automaticlly when you play a new MIDI.
//					This function is needed when you want to initialize the MIDI tempo when it
//					is playing.
///////////////////////////////////////////////////////////////////////////////////////////////////
void ResetMidiTempo();


///////////////////////////////////////////////////////////////////////////////////////////////////
//	Function:		QueryMidiCurrentTempo();
//	Parameter:		None.
//	Return : 		MIDI current Tempo value.
//	Notes:			Get current MIDI tempo.
///////////////////////////////////////////////////////////////////////////////////////////////////
unsigned int QueryMidiCurrentTempo();

///////////////////////////////////////////////////////////////////////////////////////////////////
//	Function:		QueryMidiOriginalTempo()
//	Parameter:		None.
//	Return : 		MIDI original tempo value.
//	Notes:			Get MIDI original tempo.
///////////////////////////////////////////////////////////////////////////////////////////////////
unsigned int QueryMidiOriginalTempo();

//////////////////////////////////////////////////////////////////////////////////////////
//	Setup and intitial the call back function of SPU driver while playing MIDI ends
//	InitMidiStopCallBackFuncFar( void* Func());
//  Input parameter : Far Pointer of Call back routine
//	Return : none
//////////////////////////////////////////////////////////////////////////////////////////
extern void InitMidiStopCallBackFuncFar( void *);

//////////////////////////////////////////////////////////////////////////////////////////
//	Detects if FIFO is overflow.  If yes (overflow), it will call toggle IOA.
//	Detect_FIFO_Overflow();
//  Input parameter : None
//	Return : None
//////////////////////////////////////////////////////////////////////////////////////////
extern void Detect_FIFO_Overflow(void);

///////////////////////////////////////////////////////////////////////////////////////////////////
//	Function:		sysResetMidiTempo()
//	Parameter:		None.
//	Return : 		None.
//	Notes:			Reset MIDI tempo to its initial state.
//					The MIDI tempo will be initialized automaticlly when you play a new MIDI.
//					This function is needed when you want to initialize the MIDI tempo when it
//					is playing.
///////////////////////////////////////////////////////////////////////////////////////////////////
extern void sysResetMidiTempo(void);

////////////////////////////////////////////////////////////////////////////////////////////////////
//	Plays a specified DRM file on a random channel with 4-bit ADPCM or 8/16-bit PCM mode from SFX library
//	Function:	int TM_PlayPCM_Lib(int iIndex, int iPan, int iVelocity);
//	Parameter: 	iIndex - ToneColor Index in SFX library
//				iPan - Balance value PAN
//				iVelocity - Amplitude of playing channel from 0 to maximum 127
//	Return : 	Allocated channel number for this DRM file
////////////////////////////////////////////////////////////////////////////////////////////////////
extern int TM_PlayPCM_Lib(int iIndex, int iPan, int iVelocity);


////////////////////////////////////////////////////////////////////////////////////////////////////
//	Plays a specified DRM file on a specified channel with 4-bit ADPCM or 8/16-bit PCM mode from SFX library.
//	Function:	int TM_PlayPCM_FixCH_Lib(int iChannelNo, int iIndex, int iPan, int iVelocity)
//	Parameter: 	iChannelNo - Specified channel for playing PCM/ADPCM
//				iIndex - ToneColor Index in SFX library
//				iPan - Balance value PAN
//				iVelocity - Amplitude of playing channel from 0 to maximum 127
//	Return : 	Playing channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////
extern int TM_PlayPCM_FixCH_Lib(int iChannelNo, int iIndex, int iPan, int iVelocity);


////////////////////////////////////////////////////////////////////////////////////////////////////
//	Circularly plays a specified DRM file on a specified channel with 4-bit ADPCM or 8/16-bit PCM mode from SFX library.
//	Function:	int TM_PlayLoopPCM_FixCH_Lib(int iChannelNo, int iIndex, int iPan, int iVelocity);
//	Parameter : iChannelNo - Specified channel for playing PCM/ADPCM
//				iIndex - ToneColor Index in SFX library
//				iPan - Balance value PAN
//				iVelocity - Amplitude of playing channel from 0 to maximum 127
//	Return : 	Playing channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////
extern int TM_PlayLoopPCM_FixCH_Lib(int iChannelNo, int iIndex, int iPan, int iVelocity);

////////////////////////////////////////////////////////////////////////////////////////////////////
//	Obtains the SPU driver version.
//	Function:		int Get_SPU_DrvVersion (void);
//	Parameter: 	None
//	Return : 		version number
/////////////////////////////////////////////////////////////////////////////////////////////////////
extern int Get_SPU_DrvVersion(void);



////////////////////////////////////////////////////////////////////////////////////////////////////
//	Plays a specified DRM file without envelope on a random channel with 4-bit ADPCM or 8/16-bit PCM mode from SFX library
//	Function:	int TM_PlayPCM_NoEnv_Lib(int iIndex, int iPan, int iVelocity);
//	Parameter: 	iIndex - ToneColor Index in SFX library
//				iPan - Balance value PAN
//				iVelocity - Amplitude of playing channel from 0 to maximum 127
//	Return : 	Allocated channel number for this DRM file
////////////////////////////////////////////////////////////////////////////////////////////////////
extern int TM_PlayPCM_NoEnv_Lib(int iIndex, int iPan, int iVelocity);


////////////////////////////////////////////////////////////////////////////////////////////////////
//	Plays a specified DRM file without envelope on a specified channel with 4-bit ADPCM or 8/16-bit PCM mode from SFX library.
//	Function:	int TM_PlayPCM_FixCH_Lib(int iChannelNo, int iIndex, int iPan, int iVelocity)
//	Parameter: 	iChannelNo - Specified channel for playing PCM/ADPCM
//				iIndex - ToneColor Index in SFX library
//				iPan - Balance value PAN
//				iVelocity - Amplitude of playing channel from 0 to maximum 127
//	Return : 	Playing channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////
extern int TM_PlayPCM_NoEnv_FixCH_Lib(int iChannelNo, int iIndex, int iPan, int iVelocity);

////////////////////////////////////////////////////////////////////////////////////////////////////
//	Play a specified DRM file without envelope on a random available channel with 4 bits ADPCM or 8/16 bits PCM mode 
//	TM_PlayPCM( unsigned short iSeg, unsigned short iOffset,
//				unsigned short iPan, unsigned short iVelocity);
//
//	Input parameter : 	iSeg - Segment of specified DRM file
//						iOffset - Offset of specified DRM file
//						iPan - Balance value PAN
//						iVelocity - Amplitude of playing channel from 0 to maximum 127	
//	Appendix : PAN - PAN is the value of balance, when PAN equals zero that the playing sound
//				will only effect left speaker and on the contrary while PAN equals 127 then only 
//				right speaker will be effected. The MIDDLE is at 63 or 64;
//			   DRM - DRM is a file type of Sunplus polyphony system; It can support 8 bits PCM data,  
//					 16 bits PCM or 4 bits ADPCM data modes 
//	Return : Allocated channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////   			
extern int TM_PlayPCM_NoEnv( unsigned short iSeg, unsigned short iOffset, short iPan, short iVelocity);



////////////////////////////////////////////////////////////////////////////////////////////////////
//	Play a specified DRM file without envelope on a specified channel with 4 bits ADPCM or 8/16 bits PCM mode 
//	TM_PlayPCM_FixCH( unsigned short iChannelNo, unsigned short iSeg, unsigned short iOffset,
//				unsigned short iPan, unsigned short iVelocity);
//
//	Input parameter : 	iChannelNo - Specified channel for playing PCM/ADPCM 
//						iSeg - Segment of specified DRM file
//						iOffset - Offset of specified DRM file
//						iPan - Balance value PAN
//						iVelocity - Amplitude of playing channel from 0 to maximum 127	
//	Appendix : PAN - PAN is the value of balance, when PAN equals zero that the playing sound
//				will only effect left speaker and on the contrary while PAN equals 127 then only 
//				right speaker will be effected. The MIDDLE is at 63 or 64;
//			   DRM - DRM is a file type of Sunplus polyphony system; It can support 8 bits PCM data,  
//					 16 bits PCM or 4 bits ADPCM data modes 
//	Return : Playing channel number for this DRM file
/////////////////////////////////////////////////////////////////////////////////////////////////////   			
extern int TM_PlayPCM_NoEnv_FixCH( unsigned short iChannelNo, unsigned short iSeg, unsigned short iOffset,
				unsigned short iPan, unsigned short iVelocity);



////////////////////////////////////////////////////////////////////////////////////////////////////
//	Move data address to specified bank
//	SPUSetBankOffset( unsigned short iBankOffset);
//	Input parameter : 	iBankOffset - Specified number of bank offset. 
//	Appendix : 
//	Return : NONE
/////////////////////////////////////////////////////////////////////////////////////////////////////   			
extern void SPUSetBankOffset( unsigned short iBankOffset);


/////////////////////////////////////////////////////
//	Pause the specified channel
//	TM_PausePCM( unsigned short iChannel No);
//	Input parameter : The channel number from 0 to 31
//	Return : None
/////////////////////////////////////////////////////
extern void TM_PausePCM( short iChannelNo);


/////////////////////////////////////////////////////
//	Resume the specified channel
//	TM_ResumePCM( unsigned short iChannel No);
//	Input parameter : The channel number from 0 to 31
//	Return : None
/////////////////////////////////////////////////////
extern void TM_ResumePCM( short iChannelNo);

/////////////////////////////////////////////////////
//	SPU volume select
//	SPU_VolSel( unsigned short iVolSel);
//	Input parameter : 0:1/32, 1:1/8, 2:1/2, 3:1
//	Return : None
/////////////////////////////////////////////////////
extern void SPU_VolSel( short iVolSel);

/////////////////////////////////////////////////////
//	SPU compressor enable 
//	SPU_CompressorEn( unsigned short iMode);
//	Input parameter : 0:disable 1: enable
//	Return : None
/////////////////////////////////////////////////////
extern void SPU_CompressorEn( short iMode);

#endif
