//***************************************************************************************
// Header File Included Area
//***************************************************************************************
.include ..\GPL951_Body.inc
.include ..\IO_Config.inc


//***************************************************************************************
// Constant Definition Area
//***************************************************************************************
.define C_READ_LCD_MEMORY_START_CMD		0x2E


//***************************************************************************************
// Function Call Publication Area
//***************************************************************************************

.public  _LCD_ReadOnePixelData
.public F_LCD_ReadOnePixelData
.public  _LCD_SendReadCMD
.public F_LCD_SendReadCMD
.public  _LCD_DummyRead
.public F_LCD_DummyRead


//***************************************************************************************
// RAM Definition Area
//***************************************************************************************
.RAM
.var R_LCD_RedData
.var R_LCD_GreenData
.var R_LCD_BlueData


//***************************************************************************************
// CODE Definition Area
//***************************************************************************************
.CODE
//****************************************************************
// Function    : F_LCD_SendReadCMD
// Description : 
// Destroy     : 
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _LCD_SendReadCMD:	.proc
F_LCD_SendReadCMD:
	push R1 to [SP];

	R1 = C_READ_LCD_MEMORY_START_CMD;
	[P_TFT_MemMode_WCmd] = R1;			//Write CMD 2Eh for Read TFT LCD Memory
	NOP;
	R1 = 0x2087;						//i80 write cmd
	[P_TFT_Ctrl] = R1;
	CALL	F_LCD_ReadOnePixelDelay;
	pop R1 from [SP];
	retf;
	.endp
	
//****************************************************************
// Function    : F_LCD_DummyRead
// Description : 
// Destroy     : 
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _LCD_DummyRead:	.proc
F_LCD_DummyRead:
	push R1 to [SP];

	R1 = 0x20B7;					//i80 Read data
	[P_TFT_Ctrl] = R1;		
	NOP;
	R1 = [P_TFT_MemMode_RCmd];		//first byte dummy read

	pop R1 from [SP];
	retf;
	.endp	


//****************************************************************
// Function    : F_LCD_ReadOnePixelData
// Description : read 3 Bytes data (RGB 666) and then transfer to RGB 565 format
// Destroy     : :
// Parameter   : None
// Return      : R1 : one pixel RGB565 format data
// Note        : None
//****************************************************************
 _LCD_ReadOnePixelData:	.proc
F_LCD_ReadOnePixelData:
//  RGB 565
//  b15 b14 b13 b12 b11   b10 b9  b8  b7  b6  b5   b4  b3  b2  b1  b0
//  R4  R3  R2  R1  R0    G5  G4  G3  G2  G1  G0   B4  B3  B2  B1  B0
	R1 = 0x20B7;						//i80 Read data
	[P_TFT_Ctrl] = R1;		
	CALL	F_LCD_ReadOnePixelDelay
	R1 = [P_TFT_MemMode_RCmd];
	[R_LCD_RedData] = R1;				// bit [7:2] : R5:R0
	
	R1 = 0x20B7;						// i80 Read data
	[P_TFT_Ctrl] = R1;	
	CALL	F_LCD_ReadOnePixelDelay	
	R1 = [P_TFT_MemMode_RCmd];
	[R_LCD_GreenData] = R1;				// bit [7:2] : G5:G0
	
	R1 = 0x20B7;						// i80 Read data
	[P_TFT_Ctrl] = R1;	
	CALL	F_LCD_ReadOnePixelDelay	
	R1 = [P_TFT_MemMode_RCmd];
	[R_LCD_BlueData] = R1;				// bit [7:2] : B5:B0		
	
	R1 &= 0xF8;							// keep B4:B0
	R1 = R1 lsr 3;
	R2 = [R_LCD_GreenData];
	R2 &= 0xFC;							// keep G5:G0
	R2 = R2 lsl 3;
	R1 |= R2;
	R2 = [R_LCD_RedData];
	R2 &= 0xF8;
	R2 = R2 lsl 4;
	R2 = R2 lsl 4;
	R1 |= R2;	
	
	// LCD_RGB565_Data = word data, but i80 I/F only 8 bit
	// first send high byte, than send low byte, so we shuold set high / low byte swap
//	[P_Byte_Swap] = R1;
//	R1 = [P_Byte_Swap];
	
	retf;
	.endp

//****************************************************************
// Function    : F_LCD_ReadOnePixelDelay
// Description : i80 I/F read delay
//				 When user use i80 I/F read data command ($7050 = xxBx), 
//				 must call this function, or it will get wrong data
// Destroy     : : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _LCD_ReadOnePixelDelay:	.proc
F_LCD_ReadOnePixelDelay:
	R1 = 0x08;
?L_DelayLoop:	
	R1-= 1;
	JNZ	?L_DelayLoop;
	retf;
	.endp