//**************************************************************************
// Header File Included Area
//**************************************************************************
.include GPL951_Body.inc


//***************************************************************************************
// External Variable Declaration
//***************************************************************************************
.external R_Dac1Data
.external R_Dac2Data


//**************************************************************************
// Contant Defintion Area
//**************************************************************************
.define C_DebounceCnt		0x0008
.define C_SACM_RAMP_DELAY   80
.define C_SCAN_8_Bits	    1 //0 for 16Bits

		
//**************************************************************************
// Variable Publication Area
//**************************************************************************


//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public  _System_Initial
.public F_System_Initial
.public  _System_ServiceLoop
.public F_System_ServiceLoop
.public _WatchdogClear
.public F_WatchdogClear
.public  _SP_GetCh
.public F_SP_GetCh
.public  _SP_SwitchChannel
.public F_SP_SwitchChannel

.public  _SP_RampUpDAC1
.public F_SP_RampUpDAC1
.public  _SP_RampDnDAC1
.public F_SP_RampDnDAC1
.public  _SP_RampUpDAC2
.public F_SP_RampUpDAC2
.public  _SP_RampDnDAC2
.public F_SP_RampDnDAC2

.public F_SACM_CHA_AudioOutput_Enable
.public _F_SACM_CHA_AudioOutput_Enable
.public F_SACM_CHB_AudioOutput_Enable
.public _F_SACM_CHB_AudioOutput_Enable
.public F_SACM_CHA_PlayInterrupt_Disable
.public _F_SACM_CHA_PlayInterrupt_Disable
.public F_SACM_CHB_PlayInterrupt_Disable
.public _F_SACM_CHB_PlayInterrupt_Disable
.public F_SACM_CHA_PlayInterrupt_Enable
.public F_SACM_CHB_PlayInterrupt_Enable

.public	F_SACM_CHA_WaitFIFOEmpty
.public F_SACM_CHB_WaitFIFOEmpty
.public	F_SACM_CHA_AudioOutput_Disable
.public _F_SACM_CHA_AudioOutput_Disable
.public	F_SACM_CHB_AudioOutput_Disable
.public _F_SACM_CHB_AudioOutput_Disable

.public F_ADC_Setup, F_ADC_Close
.public _F_ADC_Setup, _F_ADC_Close
.public F_SACM_ADC_Enable, F_SACM_ADC_Disable
.public F_SACM_ADC_MoniterON, F_SACM_ADC_MoniterOFF
.public F_SACM_ADC_InterruptEnable, F_SACM_ADC_InterruptDisable

.public F_SACM_Delay


//**************************************************************************
// RAM Definition Area
//**************************************************************************
.RAM
.var R_DebounceReg
.var R_DebounceCnt
.var R_KeyBuf
.var R_KeyStrobe


//**************************************************************************
// CODE Definition Area
//**************************************************************************
.CODE

//****************************************************************
// Function    : F_SP_SwitchChannel
// Description : Switch A/D channel
// Destory     : R1, R2, R3
// Parameter   : R1 = A/D channel
// Return      : None
// Note        : None
//****************************************************************
_SP_SwitchChannel: .proc
	R1 = SP + 3;
	R1 = [R1];
F_SP_SwitchChannel:

	retf;
	.endp


//****************************************************************
// Function    : F_System_Initial
// Description : System initial setting
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _System_Initial: .proc
F_System_Initial:
	int off;
	fir_mov off;
//	R1 = C_PLL_Fast_En | C_CLK96M_En | C_SYSCLK_SRC_Div1;  
//	[P_Clock_Ctrl]=r1
	
	// Set ADC Power for ADC and IOE Power
	R1 = [P_SYS_Ctrl];
	R1 |= C_ADC_Power_En + C_ADC_LDO_En;
	[P_SYS_Ctrl] = R1;
	
	// set ADC IO as input floating
	R1 = [P_IOE_Dir];
	R1 &=~0x0001;
	[P_IOE_Dir] = R1;	
	
	R1 = [P_IOE_Buffer]
	R1 &=~0x0001;
	[P_IOE_Buffer] = R1;
	
	R1 = 0x0001;
	[P_IOE_Attrib] = R1;		
	
	// IOF[15:8] for key input
	R1 = [P_IOF_Dir];
	R1 &= 0x00FF;
	[P_IOF_Dir] = R1;
	
	R1 = [P_IOF_Attrib];
	R1 &= 0x00FF;
	[P_IOF_Attrib] = R1;
	
	// IOC[11:0] for output ADC Data (Line-In0 IOE[0])
	R1 = [P_IOC_Dir];
	R1 |= 0x0FFF;
	[P_IOC_Dir] = R1;
	
	R1 = [P_IOC_Attrib];
	R1 |= 0x0FFF;
	[P_IOC_Attrib] = R1;	
	
	R1 = 0x0;
	[P_IOC_Data] = R1;		

	call	F_System_Initial_User_IO

	retf;
	.endp;

//****************************************************************
// Function    : F_Key_Scan_Initial
// Description : Key scan variable initialzation
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_Key_Scan_Initial:	.proc
	R1 = 0x0000;
	[R_DebounceReg] = R1;
	[R_KeyBuf] = R1;
	[R_KeyStrobe] = R1;
	R1 = C_DebounceCnt;
	[R_DebounceCnt] = R1;
	retf;
	.endp
	
//****************************************************************
// Function    : F_System_Initial_User_IO
// Description : I/O initialization
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_System_Initial_User_IO: .proc
	R1 = 0x0000;
	[P_IOB_Dir] = R1;
	[P_IOB_Attrib] = R1;		
	[P_IOB_Buffer] = R1;
	
	retf;
	.endp	

//****************************************************************
// Function    : F_WatchdogClear
// Description : Clear watchdog register
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
_WatchdogClear:	.proc
F_WatchdogClear:
	R1 = C_WDT_Clear;
	[P_WatchDog_Clear] = R1;
	retf;
	.endp

//****************************************************************
// Function    : F_System_ServiceLoop
// Description : Key scan and watchdog clear
// Destory     : R1, R2
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _System_ServiceLoop: .proc
F_System_ServiceLoop:
	call F_Key_DebounceCnt_Down;		// debounce counter countdown
	call F_Key_Scan_ServiceLoop;		// key scan
	call F_WatchdogClear;				// clear watchdog register
	retf;
	.endp;

//****************************************************************
// Function    : F_Key_DebounceCnt_Down
// Description : Debounce counter countdown
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_Key_DebounceCnt_Down:
	R1 = [R_DebounceCnt];
	jz	L_DebounceCntZero;
	R1 -= 0x0001;
	[R_DebounceCnt] = R1;
L_DebounceCntZero:
	retf;
	
//****************************************************************
// Function    : F_Key_Scan_ServiceLoop
// Description : Get Key code from key pad(8 x 1 key pad)
// Destory     : R1, R2
// Parameter   : None
// Return      : None
// Note        : C_SCAN_8_Bits  = 1 , ScanKey 8bits
//               C_SCAN_8_Bits  = 0 , ScanKey 16bits  
//****************************************************************
F_Key_Scan_ServiceLoop:	.proc

	//R1 = [P_IOA_Data];				// get key data from IOA  
	R1 = [P_IOF_Data];					// get key data from IOB  

.IF C_SCAN_8_Bits					// Notice, User can't operate the IOA in interrupt, because it will change the IOA configration.
	R1 &= 0xFF00; 			          
.ELSE	
	R1 &= 0xFFFF; 
.ENDIF

	R2 = [R_DebounceReg];
	[R_DebounceReg] = R1;
	cmp R2, [R_DebounceReg];
	je ?L_KS_StableTwoSample;

	R1 = C_DebounceCnt;				   // debounce counter reset
	[R_DebounceCnt] = R1;
	retf;

?L_KS_StableTwoSample:
	R1 = [R_DebounceCnt];
	jz ?L_KS_StableOverDebounce;
	retf;

?L_KS_StableOverDebounce:
	[R_DebounceCnt] = R1;
	R2 = [R_DebounceReg];
	R1 = [R_KeyBuf];
	[R_KeyBuf] = R2;

.IF  C_SCAN_8_Bits	
	R1 ^= 0xFF00;    					
	R1 = R1 and [R_KeyBuf];
	R1 &= 0xFF00;
.ELSE
	R1 ^= 0xFFFF;    					
	R1 = R1 and [R_KeyBuf];
	R1 &= 0xFFFF;
.ENDIF							
	
	R1 |= [R_KeyStrobe];
	[R_KeyStrobe] = R1;
	retf;
	.endp

//****************************************************************
// Function    : F_SP_GetCh
// Description : Get Keycode
// Destory     : R1, R2
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SP_GetCh:	.proc
F_SP_GetCh:
	R1 = [R_KeyStrobe];				// Get Key code
	R2 = 0x0000;					// Clear KeyStrobe for next key
	[R_KeyStrobe] = R2;
	retf;
	.endp

//****************************************************************
// Function    : F_SP_RampDnDAC1
// Description : Ramp down after using DAC to avoid "bow" sound from speaker 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SP_RampDnDAC1: .proc
F_SP_RampDnDAC1:
.comment @
	push R1, R2 to [SP];	
	//R1 = [P_CHA_Data];	
	R1 = [R_Dac1Data]
	R1 &= 0xFFC0;	
	cmp R1, 0x0000;
	je ?_Branch_0;
	test R1, 0x8000;
	jnz ?_Loop_0;

?_Loop_1:
	call F_SACM_Delay;
	R1 -= 0x0040;	
	[P_CHA_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_1;
	jmp ?_Branch_0;

?_Loop_0:
	call F_SACM_Delay;
	R1 += 0x0040;
	[P_CHA_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_0;

?_Branch_0:
	pop R1, R2 from [SP];
@	
	retf;
	.endp

//****************************************************************
// Function    : F_SP_RampDnDAC2
// Description : Ramp down after using DAC to avoid "bow" sound from speaker 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SP_RampDnDAC2: .proc
F_SP_RampDnDAC2:
.comment @
	push R1, R2 to [SP];
	//R1 = [P_CHB_Data];
	R1 = [R_Dac2Data]
	R1 &= 0xFFC0;
	cmp R1, 0x0000;
	je ?_Branch_0;
	test R1, 0x8000;
	jnz ?_Loop_0;

?_Loop_1:
	call F_SACM_Delay;
	R1 -= 0x0040;
	[P_CHB_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_1;

	jmp ?_Branch_0;

?_Loop_0:
	call F_SACM_Delay;
	R1 += 0x0040;
	[P_CHB_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_0;

?_Branch_0:
	pop R1, R2 from [SP];
@
	retf;
	.endp

//****************************************************************
// Function    : F_SP_RampUpDAC1
// Description : Ramp Up before using DAC to avoid "bow" sound from speaker 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SP_RampUpDAC1: .proc
F_SP_RampUpDAC1:
.comment @
	push R1, R2 to [SP];
//	R1 = [P_CHA_Data];
	R1 = [R_Dac1Data]
	R1 &= 0xFFC0;
	cmp R1, 0x0000;
	je ?_Branch_0;
	test R1, 0x8000;
	jnz ?_Loop_0;

?_Loop_1:
	call F_SACM_Delay;
	R1 -= 0x0040;
	[P_CHA_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_1;

	jmp ?_Branch_0;

?_Loop_0:
	call F_SACM_Delay;
	R1 += 0x0040;
	[P_CHA_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_0;

?_Branch_0:
	pop R1, R2 from [SP];	
@	
	retf;	
	.endp

//****************************************************************
// Function    : F_SP_RampUpDAC2
// Description : Ramp Up before using DAC to avoid "bow" sound from speaker 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SP_RampUpDAC2: .proc
F_SP_RampUpDAC2:
.comment @
	push R1, R2 to [SP];
//	R1 = [P_CHB_Data];
	R1 = [R_Dac2Data]
	R1 &= 0xFFC0;
	cmp R1, 0x0000;
	je ?_Branch_0;
	test R1, 0x8000;
	jnz ?_Loop_0;

?_Loop_1:
	call F_SACM_Delay;
	R1 -= 0x0040;
	[P_CHB_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_1;
	jmp ?_Branch_0;

?_Loop_0:
	call F_SACM_Delay;
	R1 += 0x0040;
	[P_CHB_Data] = R1;
	cmp R1, 0x0000;
	jne ?_Loop_0;

?_Branch_0:
	pop R1, R2 from [SP];
@
	retf;
	.endp
	
//****************************************************************
// Function    : F_SACM_Delay
// Description : Provide delay for Ramp up/down 
//               The delay time is adjustable by adjusting C_SACM_RAMP_DELAY
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_Delay: .proc
	R2 = C_SACM_RAMP_DELAY; // Ramp Up/Dn delay per step
?_Loop_0:
	R2 -= 0x0001;
	jnz ?_Loop_0;
	retf;
	.endp
	
	
	
//****************************************************************
// Function    : F_SACM_CHA_AudioOutput_Enable
// Description : audio channelA enable 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************	
F_SACM_CHA_AudioOutput_Enable:
_F_SACM_CHA_AudioOutput_Enable:
	R1 = C_TimerFlag | C_TimerEn | C_TimerSrcB_High | C_TimerSrcA_SYSdiv2;
	[P_TimerG_Ctrl] = R1
	r1=[P_CHA_Ctrl]
	r1|=(C_AUDIO_CHA_FIFOEmpty_Flag+C_AUDIO_CHA_FIFOEmpty_En+C_AUDIO_CHA_En+C_AUDIO_AMPNegative_En+C_AUDIO_AMPPositive_En)
	[P_CHA_Ctrl]=r1
	retf	
	

//****************************************************************
// Function    : F_SACM_CHB_AudioOutput_Enable
// Description : audio channelB enable 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************		
F_SACM_CHB_AudioOutput_Enable:
_F_SACM_CHB_AudioOutput_Enable:		
	R1 = C_TimerFlag | C_TimerEn | C_TimerSrcB_High | C_TimerSrcA_SYSdiv2;
	[P_TimerH_Ctrl] = R1

	r1 = [P_CHB_Ctrl]
	r1&=~C_AUDIO_Mono
	r1 |=(C_AUDIO_CHB_FIFOEmpty_Flag+C_AUDIO_CHB_FIFOEmpty_En+C_AUDIO_CHB_En)		
	[P_CHB_Ctrl] = r1
	
	r1=[P_CHA_Ctrl]
	r1|=(C_AUDIO_AMPPositive_En+C_AUDIO_AMPNegative_En)
	[P_CHA_Ctrl]=r1
	retf
		

//****************************************************************
// Function    : F_SACM_CHA_PlayInterrupt_Disable
// Description : audio channelA FIFO inetrrupt disable 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************				
F_SACM_CHA_PlayInterrupt_Disable:
_F_SACM_CHA_PlayInterrupt_Disable:
	r1=[P_CHB_Ctrl]						//check, is channelB INT enable?  
	test r1,C_AUDIO_CHB_FIFOEmpty_En      //if channel is disable, then trun off CHA DAC and amplifier. otherwise, turn chA DAC INT only.  
	jnz	DACOFF?							
	r1=[P_CHA_Ctrl]
//	r1&=~(C_AUDIO_CHA_FIFOEmpty_En+C_AUDIO_AMPNegative_En+C_AUDIO_AMPPositive_En)		//Frank mask 2016.06.16
	r1&=~(C_AUDIO_CHA_FIFOEmpty_En)														//Frank add 2016.06.16
	[P_CHA_Ctrl]=r1
	retf
DACOFF?:
	r1=[P_CHA_Ctrl]
	r1&=~C_AUDIO_CHA_FIFOEmpty_En
	[P_CHA_Ctrl]=r1
	retf	


//****************************************************************
// Function    : F_SACM_CHB_PlayInterrupt_Disable
// Description : audio channelB FIFO inetrrupt disable 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************	
F_SACM_CHB_PlayInterrupt_Disable:
_F_SACM_CHB_PlayInterrupt_Disable:
	r1=[P_CHA_Ctrl]						//check, is channelA enable?  
	test r1,C_AUDIO_CHA_FIFOEmpty_En 	//if channel is disable, then trun off CHB DAC and amplifier. otherwise, turn chB DAC INT only.  
	jnz	DACOFF?					
//	r1=[P_CHA_Ctrl]											//Frank mask 2016.06.16
//	r1&=~(C_AUDIO_AMPPositive_En+C_AUDIO_AMPNegative_En)	//Frank mask 2016.06.16
//	[P_CHA_Ctrl]=r1											//Frank mask 2016.06.16
DACOFF?:	
	r1=[P_CHB_Ctrl]
	r1&=~C_AUDIO_CHB_FIFOEmpty_En
	[P_CHB_Ctrl]=r1
	retf	


//****************************************************************
// Function    : F_SACM_CHA_PlayInterrupt_Enable
// Description : audio channelA FIFO inetrrupt enable 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************		
F_SACM_CHA_PlayInterrupt_Enable:
	r1=[P_CHA_Ctrl]
	r1|=(C_AUDIO_CHA_FIFOEmpty_En+C_AUDIO_AMPPositive_En+C_AUDIO_AMPNegative_En)
	[P_CHA_Ctrl]=r1
	
	r1=[P_TimerG_Ctrl]	//on/off timer for count reset
	r1&=~0x2000
	[P_TimerG_Ctrl]=r1
	r1|=0x2000
	[P_TimerG_Ctrl]=r1	
	retf	
	

//****************************************************************
// Function    : F_SACM_CHB_PlayInterrupt_Enable
// Description : audio channelB FIFO inetrrupt enable 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************		
F_SACM_CHB_PlayInterrupt_Enable:
	r1=[P_CHA_Ctrl]
	r1|=(C_AUDIO_AMPPositive_En+C_AUDIO_AMPNegative_En)
	[P_CHA_Ctrl]=r1
	
	r1=[P_CHB_Ctrl]
	r1|=C_AUDIO_CHB_FIFOEmpty_En
	[P_CHB_Ctrl]=r1
	
	r1=[P_TimerH_Ctrl]	//on/off timer for count reset
	r1&=~0x2000
	[P_TimerH_Ctrl]=r1
	r1|=0x2000
	[P_TimerH_Ctrl]=r1	
	retf	


//****************************************************************
// Function    : F_SACM_CHA_WaitFIFOEmpty
// Description : audio channelA wait FIFO empty 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************		
F_SACM_CHA_WaitFIFOEmpty:
	r1 = 0xA005
	[P_WatchDog_Clear] = r1
	r1 = [P_CHA_FIFO]
	r1 = r1 & 0x000F
	cmp r1,1							
	ja	F_SACM_CHA_WaitFIFOEmpty
	retf



//****************************************************************
// Function    : F_SACM_CHB_WaitFIFOEmpty
// Description : audio channelB wait FIFO empty 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************	
F_SACM_CHB_WaitFIFOEmpty:	
	r1 = 0xA005
	[P_WatchDog_Clear] = r1
	r1 = [P_CHB_FIFO]
	r1 = r1 & 0x000F
	cmp r1,1					
	ja	F_SACM_CHB_WaitFIFOEmpty
	retf



//****************************************************************
// Function    : F_SACM_CHA_AudioOutput_Disable
// Description : audio channelA disable
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************		
F_SACM_CHA_AudioOutput_Disable:
_F_SACM_CHA_AudioOutput_Disable:
	r1=[P_TimerG_Ctrl]
	R1 &=~C_TimerEn
	[P_TimerG_Ctrl] = R1

// ==== Frank mask 2017.02.08 for SPU =======
//	r1=[P_CHB_Ctrl]				//check, is channelB enable?  
//	test r1,C_AUDIO_CHB_En      //if channel is disable, then trun off CHA DAC and amplifier. otherwise, turn chA DAC only.  
//	jnz	DACOFF?							
//	r1=[P_CHA_Ctrl]		
//	r1&=~(C_AUDIO_CHA_En+C_AUDIO_AMPNegative_En+C_AUDIO_AMPPositive_En)
//	[P_CHA_Ctrl]=r1
//	retf
//	
//DACOFF?:	
//	r1=[P_CHA_Ctrl]
//	r1&=~(C_AUDIO_CHA_En)
//	[P_CHA_Ctrl]=r1
//=============================================	
	retf


//****************************************************************
// Function    : F_SACM_CHB_AudioOutput_Disable
// Description : audio channelB disable
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_CHB_AudioOutput_Disable:
_F_SACM_CHB_AudioOutput_Disable:	
	r1=[P_TimerH_Ctrl]
	R1 &=~C_TimerEn
	[P_TimerH_Ctrl] = R1

// ==== Frank mask 2017.02.08 for SPU =======
//	r1=[P_CHA_Ctrl]				//check, is channelA enable?  
//	test r1,C_AUDIO_CHA_En      //if channel is disable, then trun off CHB DAC and amplifier. otherwise, turn chB DAC only.  
//	jnz	DACOFF?					
//	r1=[P_CHA_Ctrl]
//	r1&=~(C_AUDIO_AMPPositive_En+C_AUDIO_AMPNegative_En)
//	[P_CHA_Ctrl]=r1
//DACOFF?:	
//	r1=[P_CHB_Ctrl]
//	r1&=~C_AUDIO_CHB_En
//	[P_CHB_Ctrl]=r1
//=============================================	
	retf

//****************************************************************
// Function    : F_ADC_Setup
// Description : enabel ADC regulator output and ADC reference voltage
//				 The ADC power and reference setup need stabel time and will increase more power consumption.
//				 So, user need enable ADC first when will use ADC function and close it immediatly when ture off ADC fucntion.     
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ADC_Setup:
_F_ADC_Setup:
	r1=[P_SYS_Ctrl]			//enable ADc regulator out
	r1|=C_ADC_Power_En
	[P_SYS_Ctrl]=r1	
	
	r1=[P_IOE_Dir]			//set IOE7(VADCref) as floating state
	r1&=~0x80
	[P_IOE_Dir]=r1
	r1=[P_IOE_Attrib]
	r1|=0x080
	[P_IOE_Attrib]=r1
							
	r1=[P_MICADC_Setup]		//enable ADC reference voltage
	r1|=C_MICADC_Vref_En
	[P_MICADC_Setup]=r1
	retf

//****************************************************************
// Function    : F_ADC_Close
// Description : Disable ADC regulator output and ADC reference voltage
//				 The ADC power and reference setup need stabel time and will increase more power consumption.
//				 So, user need enable ADC first when will use ADC function and close it immediatly when ture off ADC fucntion.     
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_ADC_Close:
_F_ADC_Close:	
	r1=[P_SYS_Ctrl]			//disable ADC regulator out
	r1&=~C_ADC_Power_En
	[P_SYS_Ctrl]=r1	
			
	r1=[P_MICADC_Setup]		//disable ADC reference voltage
	r1&=~C_MICADC_Vref_En
	[P_MICADC_Setup]=r1
	
	r1=[P_IOE_Dir]			//set IOE7(VADCref) as input pull low
	r1&=~0x80
	[P_IOE_Dir]=r1
	r1=[P_IOE_Attrib]
	r1&=~0x080
	[P_IOE_Attrib]=r1
	r1=[P_IOE_Buffer]
	r1&=~0x080
	[P_IOE_Buffer]=r1
	retf


//****************************************************************
// Function    : F_SACM_ADC_Enable
// Description : enable ADC mic and FIFO interrupt 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_ADC_Enable:
	r1=[P_IOE_Dir]			//set IOE6(MIC) as floating state
	r1&=~0x40
	[P_IOE_Dir]=r1
	r1=[P_IOE_Attrib]
	r1|=0x040
	[P_IOE_Attrib]=r1
	
	r1=	C_MICADC_AlwaysOn | C_MICADC_AGCEn | C_MICADC_SignData | C_MICADC_SysDiv128 | C_MICADC_Vref_En | C_MICADC_AutoSample_En | C_MICADC_MICEn |C_MICADC_AutoSample_Start | C_MICADC_AutoSample_TimerF;	
	[P_MICADC_Setup]=r1
	
	r1=0x0308				//set gain and enable
	[P_MICADC_GAIN]=r1	
	r1=C_MICADC_GAINEN
	[P_MICGAIN_Ctrl]=r1
	
	r1=C_MICADC_AutoSample_FF_Flag | C_MICADC_AutoSample_FF_INT | C_MICADC_AutoSample_DMA | C_MICADC_AutoSample_FF_Level4
	[P_ASMICADC_Ctrl]=r1
	
	r1=0x0101
	[P_MICADC_SH_Wait]=r1
	
	r1=[P_ASMICADC_Data]	//clear up MIC ADC data
	r1=[P_ASMICADC_Data]
	r1=[P_ASMICADC_Data]
	r1=[P_ASMICADC_Data]
	r1=[P_ASMICADC_Data]
	r1=[P_ASMICADC_Data]
	r1=[P_ASMICADC_Data]
	r1=[P_ASMICADC_Data]
	
	R1 = C_TimerFlag | C_TimerEn | C_TimerSrcB_High | C_TimerSrcA_SYSdiv2;
	[P_TimerF_Ctrl] = R1
	irq	on
	retf
	
	
//****************************************************************
// Function    : F_SACM_ADC_Disable
// Description : enable ADC mic and FIFO interrupt 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_ADC_Disable:	
	r1=[P_IOE_Dir]			//set IOE6(Mic) as input pull low
	r1&=~0x40
	[P_IOE_Dir]=r1
	r1=[P_IOE_Attrib]
	r1&=~0x040
	[P_IOE_Attrib]=r1
	r1=[P_IOE_Buffer]
	r1&=~0x040
	[P_IOE_Buffer]=r1

	r1=C_MICADC_Vref_En
	[P_MICADC_Setup]=r1
	
	r1=C_MICADC_AutoSample_FF_Flag
	[P_ASMICADC_Ctrl]=r1
	
	r1=C_TimerFlag
	[P_TimerF_Ctrl]=r1
	retf


//========================================================
// Function Name: F_SACM_ADC_InterruptEnable
// Description : ADC mic interrupt disable. This is for SACM resume function. 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//========================================================
F_SACM_ADC_InterruptEnable:
	r1 = [P_ASMICADC_Ctrl]
	r1|=C_MICADC_AutoSample_FF_INT 		// enable Interrupt
	[P_ASMICADC_Ctrl] = r1

	r1 = [P_MICADC_Setup]
	r1 |=C_MICADC_AutoSample_En			// Enable Auto Sample
	[P_MICADC_Setup] = r1
	retf

//========================================================
// Function Name: F_SACM_ADC_InterruptDisable
// Description : ADC mic interrupt disable. This is for SACM pause function. 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//========================================================
F_SACM_ADC_InterruptDisable:
	r1 = [P_ASMICADC_Ctrl]
	r1&=~C_MICADC_AutoSample_FF_INT 		// Disable Interrupt
	[P_ASMICADC_Ctrl] = r1

	r1 = [P_MICADC_Setup]
	r1 &=~C_MICADC_AutoSample_En			// Stop Auto Sample
	[P_MICADC_Setup] = r1
	retf


//****************************************************************
// Function    : F_SACM_ADC_MoniterON
// Description : ADC mic moniter enable. MIC data output to DAC channel A 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_ADC_MoniterON:
	R1 = C_TimerFlag | C_TimerEn | C_TimerSrcB_High | C_TimerSrcA_SYSdiv2;
	[P_TimerG_Ctrl] = R1
	r1=[P_CHA_Ctrl]
	r1|=(C_AUDIO_CHA_FIFOEmpty_Flag+C_AUDIO_CHA_En+C_AUDIO_AMPNegative_En+C_AUDIO_AMPPositive_En)
	[P_CHA_Ctrl]=r1
	retf
	
//****************************************************************
// Function    : F_SACM_ADC_MoniterOFF
// Description : ADC mic moniter disable. Turn off DAC channel A. 
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_ADC_MoniterOFF:
	r1=[P_TimerG_Ctrl]		//here, is for ADC monitor off	
	R1 &=~C_TimerEn
	[P_TimerG_Ctrl] = R1
	r1=[P_CHA_Ctrl]
	r1&=~(C_AUDIO_CHA_En+C_AUDIO_AMPNegative_En+C_AUDIO_AMPPositive_En)
	[P_CHA_Ctrl]=r1
	retf
	
	