
.include GPL951_body.inc

.PUBLIC _RESET,__sn_loop,__sn_loop2 
.EXTERNAL __sn_init_table,_main,__sn_sp_val
.EXTERNAL _MoveCodeToRAM

unSP_StartUp: .section .text
StartUp: .PROC
_RESET:
	FIQ off
	IRQ off
	sp = __sn_sp_val
//======================================================
//	GPL951 ROM code SPIF boot will run 1bit mode, user
//  can remove below code mask to calibration SPIF into
//  4bit mode, Note that user need add user link define
//  in link file as below :
//  Locate: GPL951_RomCodeInRAM in "Calibration.obj" at A000 linkat 100
//  ;Align: GPL951_RomCodeInRAM in "Calibration.obj" with 0 
//======================================================
	r1 = C_PLL_Fast_En + C_CLK96M_En + C_SYSCLK_SRC_Div1	
	[P_Clock_Ctrl] = r1	
	call _MoveCodeToRAM
	r3 = 0x100
	r4 = 0
	call mr							//SPIF calibration

//======================================================
//	GPL951 WatchDog default is Enable, If user want to 
//  Disable WatchDog, please remove below code mask
//======================================================
L_DisableWDT:	
	r2 = [P_PLLWaitCLK]			// P_PLLWaitCLK = 0x7818
	r1 = 0x00FF
	[P_PLLWaitCLK] = r1			// 0x7818 = 0x00FF

	r1 = C_WatchDog_Dis			// C_WatchDog_Dis = 0x0
	[P_WatchDog_Ctrl] = r1		// P_WatchDog_Ctrl =0x780A
	
	[P_PLLWaitCLK] = r2			// After set WDT Disable, write back 0x7818 original data
	
L_CheckRTC_DefaultValue: 
 //Wait V18_RTC Ready, or it can't read / write RTC register   
	 r1 = 0x1
	 [P_RTC_Ctrl] = r1  // Serial I/F Enable
	 call L_WaitReady 
  
	 r1 = 0x01
	 [P_RTC_Addr] = r1    
	 r1 = 0x2    //[0]: Write Req [1]: Read Req
	 [P_RTC_Request] = r1 
	 call L_WaitReady
	 
	 r2 = [P_RTC_ReadData]
	 r2 &= 0x01
	 r1 = 0x0
	 [P_RTC_Ctrl] = r1  // Serial I/F Disable
	 
	 test r2, 0x01
	 jz L_CheckRTC_DefaultValue 
 
        sp = __sn_init_table
        r1 = [sp++]     // item count
        jmp __judge_itcount
__next_item:
        r2 = [sp++]     // dest address (RAM)
        r3 = [sp++]     // DS of src address (ROM)
        r3 = r3 lsl 4
        r3 = r3 lsl 4
        sr = r3 lsl 2
        r3 = [sp++]     // src address (ROM)
        r4 = [sp++]     // block size
        r4 = r4 + r2
        jmp __judge_bksize
__move_data:
        bp = DS:[r3++]
        [r2++] = bp
__judge_bksize:
        cmp r2, r4
        jne __move_data
        r1 = r1 - 1
__judge_itcount:
        cmp r1, 0
        jne __next_item
__no_item:
        sp = __sn_sp_val
        call _main
__sn_loop2:
        jmp __sn_loop2
__sn_loop: 
        reti

 
L_WaitReady:
	 r1 = [P_RTC_Ready]
	 test r1, 0x1
	 jz L_WaitReady
	 retf		  
        .ENDP
        
.DEBUG
    .DW '.stabs "startup_code.",0x3c,0,0,0',0x0d,0x0a
.DEBUG
    .DW '.stabs "__sn_main:F15",36,0,0,', 0, 0
    .DW offset _main,seg _main
    .DW 0x0d,0x0a
.DEBUG
    .DW '.stabs "__sn_end:F15",36,0,0,', 0, 0
    .DW offset __sn_loop2,seg __sn_loop2
    .DW 0x0d,0x0a   
.DEBUG
    .DW '.stabs "__sn_exception:F15",36,0,0,', 0, 0
    .DW offset __sn_loop,seg __sn_loop
    .DW 0x0d,0x0a

.END
