//==================================================================================
// The information contained herein is the exclusive property of
// Generalplus Technology Co. And shall not be distributed, reproduced,
// or disclosed in whole in part without prior written permission.
//       (C) COPYRIGHT 2010   Generalplus TECHNOLOGY CO.                            
//                   ALL RIGHTS RESERVED
// The entire notice above must be reproduced on all authorized copies.
//==================================================================================
//==========================================================================
// Program Name: main.asm
// Applied body: GPL95100UA Series Body
// Programmer  : 
// Description : Rom code startup
// History version
// Rev #     Date       Who     Comments
// -----  -----------  ------   --------------------------------------------
// 1.0     2015/09/07  			Oringinal Version
// -----  -----------  ------   --------------------------------------------


//==================================================================================
// Include file area
//==================================================================================
.include GPL951_Body.inc


//=============================================
//Constant Define Area
//=============================================


//=============================================
//Public declare Area
//=============================================
.public	_MoveCodeToRAM
.public	_Halt
.public	F_Halt

.external MoveStartAddr
.external MoveEndAddr

//=============================================
//RAM Define Area
//=============================================
.ram

//=============================================
//Program Area
//=============================================
.TEXT
//************************************************************//
//Description : Move calibration code to RAM (0xA000 to 0x100)
//function : _MoveCodeToRAM
//para : 
//************************************************************//
_MoveCodeToRAM:
	push BP to [SP]
	r14 = 0x0100	//ram start addr
	r15 = 0
	r12 = seg16 MoveEndAddr
	r13 = offset MoveEndAddr
	r13 += 0x9F00			
	r12 += 0,carry	
	r1 = 0xA000
	r2 = 0
L_MovetoRAM:
	r3 = r14
	r14 += 1	
	DS = r2
	r4 = DS:[r1++]
	[r3] = r4
	r2 += 0,carry
L_CheckMoveEnd:	
	cmp	r1, r13
	jne	L_MovetoRAM
	cmp	r2, r12
	jne	L_MovetoRAM
L_MoveEnd:
	pop BP from [SP]
	retf	

//************************************************************//
//Description : Halt mode function
//function : Halt
//para : 
//************************************************************//
_Halt:
F_Halt:
	FIQ off
	IRQ off
	push BP to [SP]
	R1 = 0
	R2 = HaltRamCodeLen							
L_StoreRAM:
	R3 = [R1++]	
	push R3 to [SP]
	R2 -= 1
	jnz	L_StoreRAM
	R1 = offset HaltRamCodeStart		//Move Start addr
	R2 = seg16 HaltRamCodeStart	
	r12 = seg16 HaltRamCodeEnd		//Move End addr
	r13 = offset HaltRamCodeEnd	
	r14 = 0							//ram start addr
	r15 = 0	
L_MoveHaltRam:	
	r3 = r14
	r14 += 1	
	DS = r2
	r4 = DS:[r1++]
	[r3] = r4
	r2 += 0,carry	
	cmp	r1, r13						//CheckMoveEnd
	jne	L_MoveHaltRam
	cmp	r2, r12
	jne	L_MoveHaltRam
//L_MoveEnd:	
	R3 = 0
	R4 = 0
	call mr			//call halt mode function in RAM
	R1 = HaltRamCodeLen-1	
	R2 = HaltRamCodeLen	
L_RestoreRAM:	
	pop R3 from [SP]
	[R1--] = R3
	R2 -= 1
	jnz L_RestoreRAM
	pop BP from [SP]
	FIQ on
	IRQ on			
	retf
	
	
//===== Halt mode code in RAM =====//	
// 19 words
HaltRamCodeStart:	
F_Entering_Halt:
	r1 = [P_SPIFC_Ctrl2]		//disable SPIF
	r1 &= ~C_SPIFC_EN
	[P_SPIFC_Ctrl2]= r1	
// Enter halt mode
	r1 = 0x500A							
	[P_HALT] = r1
	nop
	nop	
	nop
	r1 = [P_SPIFC_Ctrl2]		//Enable SPIF
	r1 |= C_SPIFC_EN
	[P_SPIFC_Ctrl2]= r1
	retf  	
HaltRamCodeEnd:	
HaltRamCodeLen: .equ (HaltRamCodeEnd - HaltRamCodeStart)
	