
.external __PPUResourceTable

MyASMCode: .section .code
//====================================================================================================
//	Description:	Get 32-bit long address from PPU resource address table
//	Function:		GetLongAddress()
//	Syntax:			U32	GetLongAddress(int index);
//	Input Paramter:	int index: The index of PPU resource address table
//	Return: 		32-bit long address 			
//====================================================================================================
.public _GetLongAddress
_GetLongAddress:
	push bp to [sp];
	bp = sp+1;
	r3 = [bp+3];
	r3 = r3 lsl 1;
	
	r1 = seg16 __PPUResourceTable
	r4 = offset __PPUResourceTable
	r4 += r3
	
	r1 += 0, carry
	ds = r1
	
	r1 = ds:[r4++] //r1 offset
	r2 = ds:[r4] //r2 seg16
	
	pop bp from [sp];
	retf;

//--------------------------------------end of MyAsm.asm----------------------------------------




