//***************************************************************************************** 
// Description: GPL162xx serial PPU API
// Plateform: GPL162xx, unSP IDE 
// Edited and Created by Generalplus Technology Co., Ltd. 
//***************************************************************************************** 
#ifndef	__PPUSYSTEM_H__
#define	__PPUSYSTEM_H__
//======================================================================================================
// Type Definition Area 
//======================================================================================================
#ifndef __Uint16
#define __Uint16
typedef unsigned int	Uint16;
#endif /* #ifndef _Uint16 */

//====================================================================================================
// Union Declaration Area
//====================================================================================================
typedef union
{
	Uint16	W;
	struct
	{
		Uint16	bit0		: 1;
		Uint16	bit1		: 1;
		Uint16	bit2		: 1;
		Uint16	bit3		: 1;
		Uint16	bit4		: 1;
		Uint16	bit5		: 1;
		Uint16	bit6		: 1;
		Uint16	bit7		: 1;
		Uint16	bit8		: 1;
		Uint16	bit9		: 1;
		Uint16	bit10		: 1;
		Uint16	bit11		: 1;
		Uint16	bit12		: 1;
		Uint16	bit13		: 1;
		Uint16	bit14		: 1;
		Uint16	bit15		: 1;
	} B;
} GEN_REG_DEF;
//====================================================================================================
// Text Attribute Setting (P_Tx_Attribute)
// bit  1 - 0	: Color		Color Mode
// 				= 00   			Color 4   Mode    
//				= 01   			Color 16  Mode
//				= 10   			Color 64  Mode	 
//				= 11   			Color 256 Mode
// bit  3 - 2  	: Flip		Character Flip 
// 				= 00   			No Flip
//				= 01   			Horizontal Flip
//				= 10   			Vertical Flip
//				= 11   			Horizontal and Vertical Flip
// bit  5 - 4   : Hs			Horizontal size
// 				= 00   			8 pixels
//				= 01  	 		16 pixels
//				= 10   			32 pixels
//				= 11   			64 pixels
// bit  7 - 6   : Vs			Vertical size
// 				= 00   			8 pixels
//				= 01   			16 pixels
//				= 10   			32 pixels
//				= 11   			64 pixels
// bit 11 - 8   : Palette 	Palette bank 
//				= 0000 			Palette bank 0
//				= 0001 			Palette bank 1
//				= 0010 			Palette bank 2
//				= 0011 			Palette bank 3
//				= 0100 			Palette bank 4
//				= 0101 			Palette bank 5
//				= 0110 			Palette bank 6
//				= 0111 			Palette bank 7
//				= 1000 			Palette bank 8
//				= 1001 			Palette bank 9
//				= 1010 			Palette bank 10
//				= 1011 			Palette bank 11
//				= 1100 			Palette bank 12
//				= 1101 			Palette bank 13
//				= 1110 			Palette bank 14
//				= 1111 			Palette bank 15
// bit 13 -12   : Depth		Define Text depth layer
// 				= 00   			Depth 0 
//				= 01   			Depth 1  
//				= 10   			Depth 2 
//				= 11  	 		Depth 3 
// bit 15 -14 	: Size		Define Text size
// 				= 00   			512x256 
//				= 01   			512x512  
//				= 10   			1024x512 
//				= 11  	 		1024x1024 											
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16 Color	:2;
		Uint16 Flip		:2;
		Uint16 Hs		:2;
		Uint16 Vs		:2;
		Uint16 Palette	:4;
		Uint16 Depth	:2;
		Uint16 Size		:2;
	} B;
} P_Tx_Attribute_DEF;

//====================================================================================================
// Text Control (P_Tx_Control)
// bit  0		: BMPM			Bitmap Mode Enable
//				= 0				Character Mode
//				= 1 			Bitmap Mode	
// bit  1	  	: REGM			Register Mode Enable
//				= 0				Attribute Array Effective
//				= 1 			Register Set Effective
// bit  2		: WALL			Wallpaper Effect Enable
//				= 0				Disable(normal)
//				= 1 			Enable(Only First Character/Line attribute is effective)	
// bit  3	   	: TXEN			Text Enable 
//				= 0				Disable(Non Visible)
//				= 1 			Enable(Visible)
// bit  4   	: MVEN	 		Horizontal Movement Control Enable
//				= 0				Disable
//				= 1 			Enable
// bit  6 - 5	: MODE			Horizontal extension/compression enable(Just only Text1) 
//				= 0				Disable
//				= 1 			Enable
// bit  7	   	: RGBM			32768 High Color Mode Enable
//				= 0				Normal Mode( 4/16/64/256 colors mode)
//				= 1 			High Colors Mode (32768/65536)
// bit  8	   	: BLD			Blend Effect Control
//				= 0				Normal Mode
//				= 1 			Blend Mode
// bit  9	   	: BLDM			Blend Level Control
//				= 0				4-Level
//				= 1 			64-Level		
// bit 15 - 10 	: BLDLEV		Blend Level Value (64-Level)									
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16 Linr			:1;
		Uint16 Rgm			:1;
		Uint16 Wap			:1;
		Uint16 Txe			:1;
		Uint16 Mve			:1;
		Uint16 Mode			:2;
		Uint16 RGB			:1;
		Uint16 Bld			:1;
		Uint16 Bldm			:1;
		Uint16 BldLev		:6;
	} B;
} P_Tx_Control_DEF;

//====================================================================================================
// Sprite Control Register (P_Sp_Control)
// bit  0		: Spen			Sprite Enable
//				= 0 			Disable(Not Visible)	
//				= 1				Enable(Visible)	
// bit  1		: Coor			Sprite Coordinates Mode
//				= 0 			To cover SPG200 Sprite origin coordinates( Center of the visible area)
//				= 1				Left-upper corn of the visible area	
// bit  2		: Bldm			Sprite Blending Mode
//				= 0 			4-Level  (Register)
//				= 1				64-Level (Sprite RAM)
// bit  3		: Round			Round-robin Enable
//				= 0 			Disable
//				= 1				Enable
// bit  4		: Dir 		    Sprite Direct Address Mode
//				= 0 			Relative Address Mode
//				= 1				Direct Address Mode
// bit  5		: Mosen		    Mosaic Mode Enable
//				= 0 			Disable
//				= 1				Enable
// bit  6		: Roten		    Rotate Mode Enable
//				= 0 			Disable
//				= 1				Enable	
// bit  7		: Zoomen		Zoom Mode Enable
//				= 0 			Disable
//				= 1				Enable	
// bit 15 - 8	: Spnum			Sprite number
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16 Spen			:1;
		Uint16 Coor			:1;
		Uint16 Bldm			:1;
		Uint16 Round		:1;
		Uint16 Dir			:1;
		Uint16 Mosen		:1;
		Uint16 Roten		:1;
		Uint16 Zoomen		:1;
		Uint16 Spnum		:8;
	} B;
} P_Sp_Control_DEF;

//====================================================================================================
// Palette Control Register (P_Palette_Ctrl)
// bit  1 - 0	: Type		Palette Type
//				= 0 			16-bit Palette RAM 0 (Text/Sprite)	
//				= 1				16-bit Palette RAM 0 (Text), 16-bit Palette RAM 1 (Sprite)
//				= 2 			25-bit Palette RAM 0 and 2 (Text/Sprite) 	
//				= 3				25-bit Palette RAM 0 and 2 (Text), 25-bit Palette RAM 1 and 3 (Sprite)		
// bit  3 - 2	: Bank  		Palette RAM Bank Select
//				= 0 			Palette RAM Bank 0
//				= 1				Palette RAM Bank 1
//				= 2 			Palette RAM Bank 2
//				= 3				Palette RAM Bank 3		
// bit 15 - 4	: Reserved		
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16 Type			:2;
		Uint16 Bank			:2;		
		Uint16 Reserved		:12;
	} B;
} P_Palette_Ctrl_DEF;

//====================================================================================================
// PPU IRQ Control Resgister (P_PPU_IRQ_Ctrl)
// bit  0		: BLK_IRQ_EN		Vertical Blanking Period IRQ Enable Control	
//				= 0					Disable
//				= 1					Enable
// bit  1		: VDO_IRQ_EN		Video Timing IRQ Enable COntrol
//				= 0					Disable
//				= 1					Enable
// bit  2		: DMA_IRQ_EN		DMA IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  3		: PALERR_IRQ_EN		Paltte Write Error IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  4		: TXUR_IRQ_EN		Text Engine Under-run IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  5		: SPUR_IRQ_EN		Sprite Engine Under-run IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  6		: SENFE_IRQ_EN		Sensor Frame End IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  7		: MDFE_IRQ_EN		Motion Detect Frame End IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  8		: SENHIT_IRQ_EN		Sensor Position Hit IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  9		: MDUR_IRQ_EN		Motion Detect FIFO Under-run IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  10		: FBUR_IRQ_EN		Frame buffer FIFO Under-run IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit  11		: TVFE_IRQ_EN		TV/TFT Frame end IRQ Enable Control
//				= 0					Disable
//				= 1					Enable
// bit 15 - 12 	: Reserved
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16 BLK_IRQ_EN		:1;
		Uint16 VDO_IRQ_EN		:1;
		Uint16 DMA_IRQ_EN		:1;	
		Uint16 PALERR_IRQ_EN	:1;	
		Uint16 TXUR_IRQ_EN		:1;
		Uint16 SPUR_IRQ_EN		:1;
		Uint16 SENFE_IRQ_EN		:1;
		Uint16 MDFE_IRQ_EN		:1;
		Uint16 SENHIT_IRQ_EN	:1;	
		Uint16 MDUR_IRQ_EN		:1;	
		Uint16 FBUR_IRQ_EN		:1;
		Uint16 TVFE_IRQ_EN		:1;		
		Uint16 Reserved			:4;
	} B;
} P_IRQ_Control_DEF;

//====================================================================================================
// PPU IRQ Status Resgister (P_PPU_IRQ_Status)
// bit  0		: BLK_IRQ			Vertical Blanking IRQ Status	
//				: Write 0			No operation
//				: Write 1			Vertical Blanking IRQ clear
//				: Read 	0			Vertical Blanking Period not occurred
//				: Read  1			Vertical Blanking Period occurred
// bit  1		: VDO_IRQ			Video Timing IRQ Status
//				: Write 0			No operation
//				: Write 1			Video Timing IRQ clear
//				: Read 	0			Video Timing IRQ not occurred
//				: Read  1			Video Timing IRQ occurred
// bit  2		: DMA_IRQ			DMA IRQ Status
//				: Write 0			No operation
//				: Write 1			DMA IRQ clear
//				: Read 	0			DMA IRQ not occurred
//				: Read  1			DMA IRQ occurred
// bit  3		: PALERR_IRQ		Paltte Write Error IRQ Status
//				: Write 0			No operation
//				: Write 1			Paltte Write Error IRQ clear
//				: Read 	0			Paltte Write Error IRQ not occurred
//				: Read  1			Paltte Write Error IRQ occurred
// bit  4		: TXUR_IRQ			Text Engine Under-run IRQ Status
//				: Write 0			No operation
//				: Write 1			Text Engine Under-run IRQ clear
//				: Read 	0			Text Engine Under-run IRQ not occurred
//				: Read  1			Text Engine Under-run IRQ occurred
// bit  5		: SPUR_IRQ			Sprite Engine Under-run IRQ Status
//				: Write 0			No operation
//				: Write 1			Sprite Engine Under-run IRQ clear
//				: Read 	0			Sprite Engine Under-run IRQ not occurred
//				: Read  1			Sprite Engine Under-run IRQ occurred
// bit  6		: SENFE_IRQ			Sensor Frame End IRQ Status
//				: Write 0			No operation
//				: Write 1			Sensor Frame End IRQ clear
//				: Read 	0			Sensor Frame End IRQ not occurred
//				: Read  1			Sensor Frame End IRQ occurred
// bit  7		: MDFE_IRQ			Motion Detect Frame End IRQ Status
//				: Write 0			No operation
//				: Write 1			Motion Detect Frame End IRQ clear
//				: Read 	0			Motion Detect Frame End IRQ not occurred
//				: Read  1			PMotion Detect Frame End IRQ occurred
// bit  8		: SENHIT_IRQ		Sensor Position Hit IRQ Status
//				: Write 0			No operation
//				: Write 1			Sensor Position Hit IRQ clear
//				: Read 	0			PSensor Position Hit IRQ not occurred
//				: Read  1			Sensor Position Hit IRQ occurred
// bit  9		: MDUR_IRQ			Motion Detect FIFO Under-run IRQ Status
//				: Write 0			No operation
//				: Write 1			Motion Detect FIFO Under-run IRQ clear
//				: Read 	0			Motion Detect FIFO Under-run IRQ not occurred
//				: Read  1			Motion Detect FIFO Under-run IRQ occurred
// bit  10		: FBUR_IRQ			Frame buffer FIFO Under-run IRQ Status
//				: Write 0			No operation
//				: Write 1			Frame buffer FIFO Under-run IRQ clear
//				: Read 	0			Frame buffer FIFO Under-run IRQ not occurred
//				: Read  1			Frame buffer FIFO Under-run IRQ occurred
// bit  11		: TVFE_IRQ			TV Frame End IRQ Status
//				: Write 0			No operation
//				: Write 1			TV Frame End IRQ clear
//				: Read 	0			TV Frame End IRQ not occurred
//				: Read  1			TV Frame End IRQ occurred
// bit 15 - 12 	: Reserved
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16 BLK_IRQ			:1;
		Uint16 VDO_IRQ			:1;
		Uint16 DMA_IRQ			:1;	
		Uint16 PALERR_IRQ		:1;	
		Uint16 TXUR_IRQ			:1;
		Uint16 SPUR_IRQ			:1;
		Uint16 SENFE_IRQ		:1;
		Uint16 MDFE_IRQ			:1;
		Uint16 SENHIT_IRQ		:1;	
		Uint16 MDUR_IRQ			:1;
		Uint16 FBUR_IRQ			:1;	
		Uint16 TVFE_IRQ			:1;						
		Uint16 Reserved			:4;
	} B;
} P_IRQ_Status_DEF;

//====================================================================================================
// Sprite Attributes register0 (P_SpriteN_Attribute0)
// bit  1 -  0 	: Sp_Color		Sprite Color Mode
//				= 00			2 bits/ pixel	  4 color mode
//				= 01			4 bits/ pixel	 16 color mode
//				= 10			6 bits/ pixel	 64 color mode
//				= 11			8 bits/ pixel	256 color mode
// bit  3 -  2 	: Sp_Flip		Sprite Character Flip 
//				= 00			No Flip
//				= 01			Horizontal Flip
//				= 10			Vertical Flip
//				= 11			Horizontal and Vertical Flip
// bit  5 -  4 	: Sp_HSize		Sprite Character Horizontal Size
//				= 00			8 pixels
//				= 01			16 pixels
//				= 10			32 pixels
//				= 11			64 pixels
// bit  7 -  6 	: Sp_VSize		Sprite Character Vertical Size
//				= 00			8 pixels
//				= 01			16 pixels
//				= 10			32 pixels
//				= 11			64 pixels
// bit 11 -  8 	: Sp_Palette	Palette bank select
//				= 0000			Palette bank 0
//				= 0001			Palette bank 1
//				= 0010			Palette bank 2
//				= 0011			Palette bank 3
//				= 0100			Palette bank 4
//				= 0101			Palette bank 5
//				= 0110			Palette bank 6
//				= 0111			Palette bank 7
//				= 1000			Palette bank 8
//				= 1001			Palette bank 9
//				= 1010			Palette bank 10
//				= 1011			Palette bank 11
//				= 1100			Palette bank 12
//				= 1101			Palette bank 13
//				= 1110			Palette bank 14
//				= 1111			Palette bank 15
// bit 13 - 12 	: Sp_Depth		Define Sprite priority
//				= 00			Depth 0	
//				= 01			Depth 1	
//				= 10			Depth 2	
//				= 11			Depth 3	
// bit 14 		: Sp_Blend		Sprite Blending Effect control
//				= 0				Disable
//				= 1				Enable
// bit 15      	: Sprite palette select
//				= 0 			Palette 0
//				= 1				Palette 1
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16	Sp_Color		:2;
		Uint16	Sp_Flip			:2;
		Uint16	Sp_HSize		:2;
		Uint16	Sp_VSize		:2;
		Uint16	Sp_Palette		:4;
		Uint16	Sp_Depth		:2;
		Uint16	Sp_Blend		:1;
		Uint16	Sp_PB			:1;
	} B;
} P_Sp_Attribute0_DEF;

//====================================================================================================
// Sprite Attributes register1 (P_SpriteN_Attribute1)
// bit   7 -  0	: Sp_ChrNum		Sprite Character Number[23:16]
// bit  13 -  8	: Sp_BldLev		Sprite Blend Level (64-Level) 
// bit  15 - 14	: Sp_Mosaic		Sprite Mosaic Mode
//				= 00			No Effect
//				= 01			2 pixels
//				= 10			4 pixels
//				= 11			8 pixels
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16	Sp_ChrNum		:8;
		Uint16	Sp_BldLev		:6;
		Uint16	Sp_Mosaic		:2;
	} B;
} P_Sp_Attribute1_DEF;

//====================================================================================================
// PPU control register (P_PPU_Enable)
// bit   0		: PPUen 		PPU Enable
//				= 0				Disable
//				= 1				Enable
// bit   2		: TxDirect		Text direct mode
//				= 0				Related addreess mode
//				= 1             Direct address mode 
// bit   3   	: TxBotUp		Text calculation mode
//				= 0				Top to bottom layer
//				= 1				Bottom to top layer
// bit   4   	: VGAen			VGA mode
//				= 0				QVGA (320x240)
//				= 1				NA
// bit   5   	: VGANonIntl	VGA noninterlace mode
//				= 0				VGA interlace
//				= 1				VGA non-interlace
// bit   6   	: Free			Free address mode
//				= 0				22-bit address mode
//				= 1				27-bit address mode
// bit   7   	: FBen			Frame buffer mode
//				= 0				line-base mode
//				= 1				NC
// bit   8   	: FBformat		Frame buffer data format
//				= 0				RGB565
//				= 1				RGBG
// bit   9   	: Sp25d			Sprite layer mode
//				= 0				2D mode
//				= 1				NA
// bit  11 - 10	: FB_Mono		Frame buffer pixel resolution
//				= 0				RGB565 or RGBG format frame buffer (16 bits per pixel)
//				= 1				Mono frame buffer (1 bit per pixel)
//				= 2				4 Colors frame buffer (2 bit per pixel)
//				= 3 			16 Colors frame buffer (4 bit per pixel)
// bit  15 - 12	: Reserved
//====================================================================================================
typedef union
{
	Uint16 W;
	struct
	{
		Uint16	PPUen			:1;
		Uint16	Reserved1		:1;
		Uint16	TxDirect		:1;
		Uint16	TxBotUp			:1;
		Uint16	VGAen			:1;
		Uint16	VGANonIntl		:1;
		Uint16	Free			:1;
		Uint16	FBen			:1;
		Uint16	FBformat		:1;
		Uint16	Sp25d			:1;
		Uint16	FBmono			:2;
		Uint16	Reserved2		:4;
	} B;
} P_PPU_Enable_DEF;

//======================================================================================================
// Constant Definition Area 
//======================================================================================================
#define P_Tx1_X_Position_ADDR											0x7010
#define P_Tx1_Y_Position_ADDR											0x7011
#define P_Tx2_X_Position_ADDR											0x7016
#define P_Tx2_Y_Position_ADDR											0x7017
#define P_Tx3_X_Position_ADDR											0x7000
#define P_Tx3_Y_Position_ADDR											0x7001
#define P_Tx4_X_Position_ADDR											0x7008
#define P_Tx5_Y_Position_ADDR											0x7009
#define	P_Tx_HvOffset_ADDR												0x7100
#define	P_HComp_Value_ADDR												0x7200
#define	P_Palette_ADDR													0x7300
#define	P_Sp_Num_ADDR													0x7400
//----------------------------------------------------------------------------------------------------
// GP4 PPU register
//----------------------------------------------------------------------------------------------------
#define P_Tx1_X_Position_B			((volatile GEN_REG_DEF *)			(P_Tx1_X_Position_ADDR))	// Text1 visible area horizontal position
#define P_Tx1_Y_Position_B			((volatile GEN_REG_DEF *)			(P_Tx1_Y_Position_ADDR))	// Text1 visible area vertical position
#define P_Tx1_Attribute_B			((volatile P_Tx_Attribute_DEF *)	(0x7012))					// Set Text1 Depth , palette, V-size, H-size, File, Color mode
#define P_Tx1_Control_B        		((volatile P_Tx_Control_DEF *)		(0x7013))					// Set BMP/Character Mode, some effect enable 
#define P_Tx1_N_Ptr_B          		((volatile GEN_REG_DEF *)			(0x7014))					// Text1 Character Number array pointer
#define P_Tx1_A_Ptr_B	            ((volatile GEN_REG_DEF *)			(0x7015))					// Text1 Attribute array pointer
#define P_Tx2_X_Position_B			((volatile GEN_REG_DEF *)			(P_Tx2_X_Position_ADDR))	// Text2 visible area horizontal position
#define P_Tx2_Y_Position_B			((volatile GEN_REG_DEF *)			(P_Tx2_Y_Position_ADDR))	// Text2 visible area vertical position
#define P_Tx2_Attribute_B			((volatile P_Tx_Attribute_DEF *)	(0x7018))					// Set Text2 Depth , palette, V-size, H-size, File, Color mode
#define P_Tx2_Control_B        		((volatile P_Tx_Control_DEF *)		(0x7019))					// Set BMP/Character Mode, some effect enable 	
#define P_Tx2_N_Ptr_B          		((volatile GEN_REG_DEF *)			(0x701a))					// Text2 Character Number array pointer
#define P_Tx2_A_Ptr_B	            ((volatile GEN_REG_DEF *)			(0x701b))					// Text2 Attribute array pointer
#define P_Tx3_X_Position_B			((volatile GEN_REG_DEF *)			(P_Tx3_X_Position_ADDR))	// Text3 visible area horizontal position
#define P_Tx3_Y_Position_B			((volatile GEN_REG_DEF *)			(P_Tx3_Y_Position_ADDR))	// Text3 visible area vertical position
#define P_Tx3_X_Offset_B			((volatile GEN_REG_DEF *)			(0x7002))					// Text3 horizontal offset
#define P_Tx3_Y_Offset_B			((volatile GEN_REG_DEF *)			(0x7003))					// Text3 vertical offset
#define P_Tx3_Attribute_B			((volatile P_Tx_Attribute_DEF *)	(0x7004))					// Set Text3 Depth , palette, V-size, H-size, File, Color mode
#define P_Tx3_Control_B          	((volatile P_Tx_Control_DEF *)		(0x7005))					// Set BMP/Character Mode, some effect enable 	
#define P_Tx3_N_Ptr_B            	((volatile GEN_REG_DEF *)			(0x7006))					// Text3 Character Number array pointer
#define P_Tx3_A_Ptr_B		        ((volatile GEN_REG_DEF *)			(0x7007))					// Text3 Attribute array pointer
#define P_Tx4_X_Position_B			((volatile GEN_REG_DEF *)			(P_Tx4_X_Position_ADDR))	// Text4 visible area horizontal position
#define P_Tx4_Y_Position_B			((volatile GEN_REG_DEF *)			(P_Tx4_Y_Position_ADDR))	// Text4 visible area vertical position
#define P_Tx4_X_Offset_B			((volatile GEN_REG_DEF *)			(0x700a))					// Text4 horizontal offset
#define P_Tx4_Y_Offset_B			((volatile GEN_REG_DEF *)			(0x700b))					// Text4 vertical offset
#define P_Tx4_Attribute_B			((volatile P_Tx_Attribute_DEF *)	(0x700c))					// Set Text4 Depth , palette, V-size, H-size, File, Color mode
#define P_Tx4_Control_B        		((volatile P_Tx_Control_DEF *)		(0x700d))					// Set BMP/Character Mode, some effect enable 	
#define P_Tx4_N_Ptr_B          		((volatile GEN_REG_DEF *)			(0x700e))					// Text4 Character Number array pointer
#define P_Tx4_A_Ptr_B	            ((volatile GEN_REG_DEF *)			(0x700f))					// Text4 Attribute array pointer
#define P_VComp_Value_B				((volatile GEN_REG_DEF *)			(0x701c))					// Vertical compression/extension value
#define P_VComp_Offset_B			((volatile GEN_REG_DEF *)			(0x701d))					// compression/extension scale movement control register
#define P_VComp_Step_B				((volatile GEN_REG_DEF *)			(0x701e))					// 0x01-0x7f: small to biger, 0xff-0x80: bigger to small
#define P_Segment_Tx1_B				((volatile GEN_REG_DEF *)			(0x7020))					// Text1 Segment register
#define P_Segment_Tx2_B				((volatile GEN_REG_DEF *)			(0x7021))					// Text2 Segment register
#define P_Segment_Sp_B				((volatile GEN_REG_DEF *)			(0x7022))					// Sprite Segment register
#define P_Segment_Tx3_B				((volatile GEN_REG_DEF *)			(0x7023))					// Text3 Segment register
#define P_Segment_Tx4_B				((volatile GEN_REG_DEF *)			(0x7024))					// Text4 Segment register
#define P_Tx4_Cosine_B				((volatile GEN_REG_DEF *)			(0x7028))					// Text4 cosine register
#define P_Tx4_Sine_B				((volatile GEN_REG_DEF *)			(0x7029))					// Text4 sine register
#define	P_Blending_B				((volatile GEN_REG_DEF *)			(0x702a))					// Text blending effect control register
#define	P_Segment_Tx1H_B			((volatile GEN_REG_DEF *)			(0x702b))					// TEXT1 segment address high word register
#define	P_Segment_Tx2H_B			((volatile GEN_REG_DEF *)			(0x702c))					// TEXT2 segment address high word register
#define	P_Segment_SpH_B				((volatile GEN_REG_DEF *)			(0x702d))					// Sprite segment address high word register
#define	P_Segment_Tx3H_B			((volatile GEN_REG_DEF *)			(0x702e))					// TEXT3 segment address high word register
#define	P_Segment_Tx4H_B			((volatile GEN_REG_DEF *)			(0x702f))					// TEXT4 segment address high word register
#define P_Fade_Control_B			((volatile GEN_REG_DEF *)			(0x7030))					// Fade effect control register
#define P_IRQTMV_B					((volatile GEN_REG_DEF *)			(0x7036))					// Video timing IRQ V Position
#define P_IRQTMH_B					((volatile GEN_REG_DEF *)			(0x7037))					// Video timing IRQ H Position
#define	P_Line_Counter_B			((volatile GEN_REG_DEF *)			(0x7038))					// TV line counter register
#define	P_LP_Control_B				((volatile GEN_REG_DEF *)			(0x7039))					// Light pen control register
#define	P_Palette_Control_B			((volatile P_Palette_Ctrl_DEF *)	(0x703a))					// Palette control register
#define P_TV_Control_B             	((volatile GEN_REG_DEF *)			(0x703c))					// TV control register	
#define P_LPVPosition_B		        ((volatile GEN_REG_DEF *)			(0x703f))					// Light Pen I/F V Position
#define P_LPHPosition_B				((volatile GEN_REG_DEF *)			(0x703e))					// Light Pen I/F H Position
#define P_Sp_Control_B              ((volatile P_Sp_Control_DEF *)		(0x7042))					// Sprite Control Register Bit0: Enable Bit1: coordinates mode select
#define P_PPU_IRQ_Control_B        	((volatile P_IRQ_Control_DEF *)		(0x7062))					// IRQ Control Register
#define P_PPU_IRQ_Status_B         	((volatile P_IRQ_Status_DEF *)		(0x7063))					// IRQ Status/Clear
#define P_SPDMA_Source_B        	((volatile GEN_REG_DEF *)			(0x7070))					// Sprite DMA source start address
#define P_SPDMA_Target_B        	((volatile GEN_REG_DEF *)			(0x7071))					// Sprite DMA target start address
#define P_SPDMA_Number_B           	((volatile GEN_REG_DEF *)			(0x7072))					// Sprite DMA transfer number & trigger to start
#define P_PPU_Enable_B				((volatile P_PPU_Enable_DEF *)		(0x707f))					// PPU control register
#define P_Tx_HvOffsetN_B            ((volatile GEN_REG_DEF *)			(P_Tx_HvOffset_ADDR))		// Text Horizontal movement control registers line 0
#define P_HComp_ValueN_B	        ((volatile GEN_REG_DEF *)			(P_HComp_Value_ADDR))		// Text Herizontal extension/compression scale register line 0
#define P_PaletteN_B                ((volatile GEN_REG_DEF *)			(P_Palette_ADDR))			// Color Palette 	
#define P_SpriteN_CharNum_B         ((volatile GEN_REG_DEF *)			(P_Sp_Num_ADDR)) 			// Sprite Character Number
#define P_SpriteN_X_B               ((volatile GEN_REG_DEF *)			(0x7401))					// Sprite Horizontal position
#define P_SpriteN_Y_B               ((volatile GEN_REG_DEF *)			(0x7402))					// SPrite Vertical position
#define P_SpriteN_Attribute0_B      ((volatile P_Sp_Attribute_DEF *)	(0x7403))					// Sprite Attributes register 0
#define P_SpriteN_Attribute1_B      ((volatile P_Sp_Attribute_DEF *)	(0x7400))					// Sprite Attributes register 1


#endif




