#ifndef __drv_l1_TFT_H__
#define __drv_l1_TFT_H__


//#include "driver_l1.h"
//#include "drv_l1_sfr.h"

#define TFT_EN                  (1<<0)
#define TFT_CLK_SEL             (7<<1)
#define TFT_MODE                (0xF<<4)
#define TFT_VSYNC_INV           (1<<8)
#define TFT_HSYNC_INV           (1<<9)
#define TFT_DCLK_INV            (1<<10)
#define TFT_DE_INV              (1<<11)
#define TFT_H_COMPRESS          (1<<12)
#define TFT_MEM_BYTE_EN         (1<<13)
#define TFT_INTERLACE_MOD       (1<<14)
#define TFT_VSYNC_UNIT          (1<<15)

#define TFT_REG_POL             (1<<4)
#define TFT_REG_REV             (1<<5)
#define TFT_UD_I                (1<<6)
#define TFT_RL_I                (1<<7)
#define TFT_DITH_EN             (1<<8)
#define TFT_DITH_MODE           (1<<9)
#define TFT_DATA_MODE           (3<<10)
#define TFT_SWITCH_EN           (1<<12)
#define TFT_GAMMA_EN            (1<<13)
#define TFT_DCLK_SEL            (3<<14)
#define TFT_DCLK_DELAY          (7<<18)
#define TFT_SLIDE_EN            (1<<21)

#define TFT_MODE_UPS051         0x0
#define TFT_MODE_UPS052         0x10
#define TFT_MODE_CCIR656        0x20
#define TFT_MODE_PARALLEL       0x30
#define TFT_MODE_TCON           0x40

#define TFT_MODE_MEM_CMD_WR     0x80
#define TFT_MODE_MEM_CMD_RD     0x90
#define TFT_MODE_MEM_DATA_WR    0xa0
#define TFT_MODE_MEM_DATA_RD    0xb0
#define TFT_MODE_MEM_CONTI      0xc0
#define TFT_MODE_MEM_ONCE       0xd0


#define TFT_DATA_MODE_8         0x0             
#define TFT_DATA_MODE_565	    0x400
#define TFT_DATA_MODE_666       0x800
#define TFT_DATA_MODE_888       0xC00

#define TFT_DCLK_SEL_0          0x0000
#define TFT_DCLK_SEL_90         0x4000
#define TFT_DCLK_SEL_180        0x8000
#define TFT_DCLK_SEL_270        0xC000

#define TFT_DCLK_DELAY_0        0x000000
#define TFT_DCLK_DELAY_1        0x040000
#define TFT_DCLK_DELAY_2        0x080000
#define TFT_DCLK_DELAY_3        0x0C0000
#define TFT_DCLK_DELAY_4        0x100000
#define TFT_DCLK_DELAY_5        0x140000
#define TFT_DCLK_DELAY_6        0x180000
#define TFT_DCLK_DELAY_7        0x1C0000

#define TFT_REG_POL_1LINE       0x0
#define TFT_REG_POL_2LINE       0x1
#define TFT_NEW_POL_EN          0x80

#define PWM_VSET                0x70
#define PWM_VSET_BIT            4

#define IOE_PIN_RST			1		//TFT : /RST Pin
#define IOE_PIN_1			2		//TFT : /CS	Pin
#define A116_T180LA			0

void LCD_SetWindow(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2);
void tft_start(int model);
void gpio_write_io(int port, int data);
void gpio_init_io(int port, int direction);
void gpio_set_port_attribute(int port, int attribute);
int gpio_read_io(int port);
void i80_write_cmd(char cmd);
void i80_read_cmd(char cmd);
int i80_read_data(void);

#endif 		/* __drv_l1_TFT_H__ */