//==========================================================================
// File Name   : SACM_A1800_USER.asm
// Description : Users implement functions
// Written by  : Ray Cheng
// Last modified date:
//              2005/12/26
// Note: 
//==========================================================================
//**************************************************************************
// Header File Included Area
//**************************************************************************
.include GPL951_Body.inc
.include A1800.inc
//.include Resource.inc


//**************************************************************************
// Table Publication Area
//**************************************************************************
.public D_SW_PWM_LEVEL
.public T_IO_Event
.public D_IO_EVENT_NUM


//***************************************************************************************
// User Definition Section for IO Event
//***************************************************************************************
.define SystemClock				96000000
.define C_Timer_Setting_8K    	65536 - (SystemClock / 2 / 8000)
.define C_Timer_Setting_16K    	65536 - (SystemClock / 2 / 16000)
.define C_Timer_Setting_32K    	65536 - (SystemClock / 2 / 32000)
.define C_Timer_Setting_64K    	65536 - (SystemClock / 2 / 64000)

.define C_A1800_Timer_Setting_X1		C_Timer_Setting_16K
.define C_A1800_Timer_Setting_X2		C_Timer_Setting_32K
.define C_A1800_Timer_Setting_X4		C_Timer_Setting_64K

.define C_IO_EVENT_NUM    0                      // IO number for IO_Event.
.define C_SW_PWM_FREQ     60                     // PWM frequency (Unit: Hz)
.define C_SW_PWM_LEVEL    128                    // PWM level selection (32/64/128/256)
.define C_PWM_FREQ        65536 - (SystemClock / 2 / (C_SW_PWM_FREQ * C_SW_PWM_LEVEL))      // for PWM Service Timer Setting

.text 
//
// IO Event Definition
// - Mapped to the number of Edit Event on G+ Eventor
//
T_IO_Event:
.DD    C_IOA0
.DD    C_IOA1
.DD    C_IOA2
.DD    C_IOA3
.DD    C_IOA4
.DD    C_IOB0
.DD    C_IOB1
.DD    C_IOB2
.DD    C_IOB3
.DD    C_IOB4
.DD    C_IOB5
.DD    C_IOB6
.DD    C_IOB7


//**************************************************************************
// Contant Defintion Area
//**************************************************************************
.define C_SpeechNumberLength		4	// for skip song number

.define C_NeedToChangeBank			0
//
// IO Event Pin Definition Section
// - Based on IC I/O Configuration         
// - example ".define C_IOA3            0x78600003"
//   1st word:0x7860 = I/O Configuration Register Base
//   2st word:0x0003 = I/O Pin Number
//
.define C_IOA0            0x78600000
.define C_IOA1            0x78600001  
.define C_IOA2            0x78600002
.define C_IOA3            0x78600003
.define C_IOA4            0x78600004 
.define C_IOB0            0x78680000
.define C_IOB1            0x78680001  
.define C_IOB2            0x78680002
.define C_IOB3            0x78680003
.define C_IOB4            0x78680004 
.define C_IOB5            0x78680005 
.define C_IOB6            0x78680006 
.define C_IOB7            0x78680007 

.define C_PORT_DATA_IDX   0 
.define C_PORT_BUF_IDX    1
.define C_PORT_DIR_IDX    2
.define C_PORT_ATT_IDX    3


//**************************************************************************
// Variable Publication Area
//**************************************************************************
.public R_DutyArray 
.public R_Dac1Data
.public R_Dac2Data


//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public  _USER_A1800_SetStartAddr
.public F_USER_A1800_SetStartAddr
.public  _USER_A1800_SetStartAddr_Con
.public F_USER_A1800_SetStartAddr_Con
.public F_USER_A1800_GetData
.public  _USER_A1800_Volume
.public F_USER_A1800_Volume
.public F_SACM_A1800_SendDAC1
.public F_SACM_A1800_SendDAC2
.public F_SACM_A1800_StartPlay
.public F_SACM_A1800_EndPlay
.public F_SACM_A1800_Init_
.public F_SACM_A1800_DAC1_Timer_X1
.public F_SACM_A1800_DAC1_Timer_X2
.public F_SACM_A1800_DAC2_Timer_X1
.public F_SACM_A1800_DAC2_Timer_X2
.public F_SACM_A1800_GetStartAddr_Con
.public F_Event_Init_
.public F_GetExtSpeechStartAddr
.public F_USER_GetEvtData
.public F_USER_IoEvtStart
.public F_USER_IoEvtEnd
.public F_USER_EvtProcess


//**************************************************************************
// External Function Declaration
//**************************************************************************


//**************************************************************************
// External Table Declaration
//**************************************************************************


//**************************************************************************
// RAM Definition Area
//**************************************************************************
.RAM
R_DutyArray:    .dw    C_IO_EVENT_NUM    dup(?)  // Used by A1800 Library for IO Event

.var R_Dac1Data
.var R_Dac2Data


//*****************************************************************************
// Table Definition Area
//*****************************************************************************
.TEXT
// Volume Table
T_SACM_A1800_Volume_Level:
.dw 0x0000, 0x0250, 0x0500, 0x1000
.dw	0x1500, 0x2000, 0x2500, 0x3000
.dw 0x3500, 0x4000, 0x5000, 0x6500
.dw	0x7d00, 0x9c00, 0xc400, 0xf500

D_SW_PWM_LEVEL:
.DW C_SW_PWM_LEVEL

D_IO_EVENT_NUM:
.DW C_IO_EVENT_NUM

//**************************************************************************
// CODE Definition Area
//**************************************************************************
.CODE
//****************************************************************
// Function    : F_SACM_A1800_Init_
// Description : Hardware initilazation for A1800, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_A1800_Init_:	.proc
	FIR_MOV OFF;
    
	R1 = C_AUDIO_Sign_En | C_AUDIO_DAC_1CH | 0x68;    
	[P_CHA_Ctrl] = R1 	

    R1 = C_AUDIO_FIFO_Reset + 0x070	//reset FIFO and set FIFO level
    [P_CHA_FIFO] = R1
    [P_CHB_FIFO] = R1
	
	R1 = C_A1800_Timer_Setting_X1
	[P_TimerG_Preload] = R1		    
	[P_TimerH_Preload] = R1		    
	
	irq on;				
	retf;
	.endp

//****************************************************************
// Function    : F_USER_A1800_Volume
// Description : Set speech volume
// Destory     : R1
// Parameter   : R1: volume index
// Return      : None
// Note        : None
//****************************************************************
 _USER_A1800_Volume: .proc
	R1 = SP + 3;
	R1 = [R1];								// volume index
F_USER_A1800_Volume:
	R1 += T_SACM_A1800_Volume_Level;		// loop up volume table
	R1 = [R1];
	call F_SACM_A1800_Volume;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_A1800_DAC1_Timer_X1
// Description : Change timer setting for change DA filter, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_A1800_DAC1_Timer_X1:	.proc
F_SACM_A1800_DAC1_Timer_X1:
    push R1 to [SP];

	R1 = C_A1800_Timer_Setting_X1;
	[P_TimerG_Preload] = R1;
	
	pop R1 from [SP];
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_A1800_DAC2_Timer_X1
// Description : Change timer setting for change DA filter, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_A1800_DAC2_Timer_X1:	.proc
F_SACM_A1800_DAC2_Timer_X1:
    push R1 to [SP];

	R1 = C_A1800_Timer_Setting_X1;
	[P_TimerH_Preload] = R1;
	
	pop R1 from [SP];
	retf;
	.endp


//****************************************************************
// Function    : F_SACM_A1800_DAC1_Timer_X2
// Description : Set timer for A1800 playback, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_A1800_DAC1_Timer_X2:	.proc
F_SACM_A1800_DAC1_Timer_X2:
	push R1 to [SP];
	
	R1 = C_A1800_Timer_Setting_X2;
	[P_TimerG_Preload] = R1;
	
	pop R1 from [SP];
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_A1800_DAC2_Timer_X2
// Description : Set timer for A1800 playback, called by library
// Destory     : R1
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
 _SACM_A1800_DAC2_Timer_X2:	.proc
F_SACM_A1800_DAC2_Timer_X2:
	push R1 to [SP];
	
	R1 = C_A1800_Timer_Setting_X2;
	[P_TimerH_Preload] = R1;
	
	pop R1 from [SP];
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_A1800_SendDAC1
// Description : Send data to DAC1, called by library
// Destory     : None
// Parameter   : R4: 16-bit signed PCM data
// Return      : None
// Note        : None
//****************************************************************
F_SACM_A1800_SendDAC1:	.proc	
	[P_CHA_Data] = R4
	[R_Dac1Data] = R4;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_A1800_SendDAC2
// Description : Send data to DAC2, called by library
// Destory     : None
// Parameter   : R4: 16-bit signed PCM data
// Return      : None
// Note        : None
//****************************************************************
F_SACM_A1800_SendDAC2:	.proc
    [P_CHB_Data] = R4;   
    [R_Dac2Data] = R4;
	retf; 
	.endp

//****************************************************************
// Function    : F_SACM_A1800_StartPlay
// Description : This function called by library when Play function is callled
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_A1800_StartPlay:	.proc
	nop;
	retf;
	.endp

//****************************************************************
// Function    : F_SACM_A1800_EndPlay
// Description : This function called by library when speech play end
// Destory     : None
// Parameter   : None
// Return      : None
// Note        : None
//****************************************************************
F_SACM_A1800_EndPlay:	.proc
	nop;
	retf;
	.endp

//****************************************************************
// Function    : F_USER_A1800_SetStartAddr
// Description : This API allows users to set the beginning address
//               to fetch data. This address can be either a ROM address
//               or a external storage address. User would have to modify
//               the function body based on the application's need.
// Destory     : None
// Parameter   : R1: Speech index
// Return      : None
// Note        : None
//****************************************************************
_USER_A1800_SetStartAddr:	.proc
	R1 = SP + 3;
	R1 = [R1];
F_USER_A1800_SetStartAddr:	
  		
	retf;
	.endp

//****************************************************************
// Function    : F_USER_A1800_SetStartAddr_Con
// Description : This API allows users to set the beginning address
//               to fetch data. This address can be either a ROM address
//               or a external storage address. User would have to modify
//               the function body based on the application's need.
// Destory     : None
// Parameter   : R1: Low byte of start address
//               R2: High byte of start address
// Return      : None
// Note        : None
//****************************************************************
_USER_A1800_SetStartAddr_Con:	.proc
	R1 = SP + 3;
	R1 = [R1];
F_USER_A1800_SetStartAddr_Con:

	retf;
	.endp	

//****************************************************************
// Function    : F_SACM_A1800_GetStartAddr_Con
// Description : 
// Destory     : None
// Parameter   : 
// Return      : None
// Note        : None
//****************************************************************
F_SACM_A1800_GetStartAddr_Con:	.proc

	retf;
	.endp

//****************************************************************
// Function    : F_USER_A1800_GetData
// Description : Get speech data from internal or external memory
//               and fill these data to buffer of library.
// Destory     : None
// Parameter   : R1: decode buffer address of library
//               R2: data length
// Return      : None
// Note        : None
//****************************************************************
F_USER_A1800_GetData:	.proc
	
	retf;
	.endp

//*****************************************************************************
// Function    : F_Event_Init_
// Description : None
// Destory     : 
// Parameter   : None
// Return      : None
// Note        : None
//***************************************************************************** 
F_Event_Init_:    .proc
	push R1, R5 to [sp];

	//
	// Initialize S/W PWM IO as output low
	// 	
	R1 = 0;  
	R2 = T_IO_Event; 	
?L_IOSettingLoop:   
	R3 = [R2++];
	R5 = [R2++];  
	R4 = [R5 + C_PORT_DIR_IDX];
	setb R4, R3;
	[R5 + C_PORT_DIR_IDX] = R4; 
	R4 = [R5 + C_PORT_ATT_IDX];
	setb R4, R3;     
	[R5 + C_PORT_ATT_IDX] = R4;   
	R4 = [R5 + C_PORT_BUF_IDX];
	clrb R4, R3;
	[R5 + C_PORT_BUF_IDX] = R4;  	
	R1 += 1;
	cmp R1, C_IO_EVENT_NUM;
	jb ?L_IOSettingLoop 
	
	//
	// Initialize TimerC and enable IRQ2_TimerC interrupt
	//
	R1 = [P_TimerA_Ctrl];	
	R1 |= C_TimerFlag | C_TimerIntEn | C_TimerEn | C_TimerSrcB_High | C_TimerSrcA_SYSdiv2;
	[P_TimerA_Ctrl] = R1;
	
	R1 = C_PWM_FREQ;
	[P_TimerA_Preload] = R1;
	
	R1 = [P_INT_Priority3];
	R1 &= ~C_TMA_FIQ;
	[P_INT_Priority3] = R1;  
	IRQ ON;  

?L_Event_Init_End:
	pop R1, R5 from [sp];	
	retf;
	.endp

//*****************************************************************************
// Function    : F_GetExtSpeechStartAddr
// Description : In the manual mode, library call this function to get 
//               external speech start address.
// Destory     : None
// Parameter   :
// Return      : R1 = Low ward of sound data addr  (byte mode address)
//               R2 = High ward of sound data addr (byte mode address)
// Note        : None
//*****************************************************************************
F_GetExtSpeechStartAddr:	.proc	
  
	retf;
	.endp

//*****************************************************************************
// Function    : F_USER_GetEvtData
// Description : In the manual mode, library call this function to get 
//               external event data. 
// Destory     : None
// Parameter   : R1 = Low ward of the event data addr  (byte mode address)  
//               R2 = High ward of the event data addr (byte mode address)
// Return      : R1 = Event Data
// Note        : None
//*****************************************************************************
F_USER_GetEvtData:	.proc
    
    retf;	
	.endp

//*****************************************************************************
// Function    : F_USER_IoEvtStart
// Description : This function will be called by library when IO event start.
//               The state of IO pins can be set by user 
// Destory     : 
// Parameter   : None
// Return      : None
// Note        : None
//*****************************************************************************    
F_USER_IoEvtStart:    .proc 
	push R1, BP to [sp];
	
	//
	// Set S/W PWM IO as output low
	//	
	R1 = 0;  
	R2 = T_IO_Event;  
?L_IOSettingLoop:   
	R3 = [R2++];
	R5 = [R2++];
	R4 = [R5 + C_PORT_BUF_IDX];
	clrb R4, R3;
	[R5 + C_PORT_BUF_IDX] = R4;   
	//R4 = [R5 + C_PORT_DIR_IDX];
	//setb R4, R3;
	//[R5 + C_PORT_DIR_IDX] = R4;  
	R1 += 1;
	cmp R1, C_IO_EVENT_NUM;
	jb ?L_IOSettingLoop 

	pop R1, BP from [sp];
	retf
	.endp

//*****************************************************************************
// Function    : F_USER_IoEvtEnd
// Description : This function will be called by library when IO event ends.
//               The state of IO pins can be set by user 
// Destory     : 
// Parameter   : None
// Return      : None
// Note        : None
//*****************************************************************************    
F_USER_IoEvtEnd:    .proc 
	push R1, BP to [sp];
	
	//
	// Set S/W PWM IO as output low
	//	
	R1 = 0;  
	R2 = T_IO_Event;  
?L_IOSettingLoop:   
	R3 = [R2++];
	R5 = [R2++];
	R4 = [R5 + C_PORT_BUF_IDX];
	clrb R4, R3;
	[R5 + C_PORT_BUF_IDX] = R4;   
	//R4 = [R5 + C_PORT_DIR_IDX];
	//setb R4, R3;
	//[R5 + C_PORT_DIR_IDX] = R4;  
	R1 += 1;
	cmp R1, C_IO_EVENT_NUM;
	jb ?L_IOSettingLoop 

	pop R1, BP from [sp];
	retf
	.endp
	
//*****************************************************************************
// Function    : F_USER_EvtProcess
// Description : When a user event is decoded, F_USER_EvtProcess will be executed.
//               User can process the user event in this function.
// Destory     : 
// Parameter   : R1 = SubIndex(8-bits):MainIndex(8-bits) 
// Return      : None
// Note        : None
//*****************************************************************************
F_USER_EvtProcess:    .proc  
	
	retf
	.endp

